/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Err_;
import gplx.String_;
import gplx.core.texts.StringTableColAlign;

public class StringTableCol {
    StringTableColAlign halign = StringTableColAlign.Left;
    int lengthMax = Integer.MIN_VALUE;
    int lengthMin = Integer.MAX_VALUE;

    public StringTableColAlign Halign() {
        return this.halign;
    }

    public StringTableCol Halign_(StringTableColAlign val) {
        this.halign = val;
        return this;
    }

    public int LengthMax() {
        return this.lengthMax;
    }

    public int LengthMin() {
        return this.lengthMin;
    }

    public void AdjustFor(String s) {
        int length = String_.Len(s);
        if (length > this.lengthMax) {
            this.lengthMax = length;
        }
        if (length < this.lengthMin) {
            this.lengthMin = length;
        }
    }

    public String PadCell(String cell) {
        int diff = this.lengthMax - String_.Len(cell);
        int val = this.halign.Val();
        if (val == StringTableColAlign.Left.Val()) {
            return String.valueOf(cell) + String_.Repeat(" ", diff);
        }
        if (val == StringTableColAlign.Right.Val()) {
            return String.valueOf(String_.Repeat(" ", diff)) + cell;
        }
        if (val == StringTableColAlign.Mid.Val()) {
            return String_.Concat(String_.Repeat(" ", diff / 2), cell, String_.Repeat(" ", diff / 2 + diff % 2));
        }
        throw Err_.new_unhandled(this.halign.Val());
    }

    public static StringTableCol new_() {
        return new StringTableCol();
    }

    StringTableCol() {
    }

    public static StringTableCol as_(Object obj) {
        return obj instanceof StringTableCol ? (StringTableCol)obj : null;
    }

    public static StringTableCol cast(Object obj) {
        try {
            return (StringTableCol)obj;
        }
        catch (Exception exc) {
            throw Err_.new_type_mismatch_w_exc(exc, StringTableCol.class, obj);
        }
    }
}

