/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Tfds;
import gplx.core.texts.RegxPatn_cls_ioMatch;
import gplx.core.texts.RegxPatn_cls_ioMatch_;
import org.junit.Test;

public class RegxPatn_cls_ioMatch_tst {
    @Test
    public void SimpleMatches() {
        this.tst_Matches("file.cs", "file.cs", true);
        this.tst_Matches("file.cs", "file.cs.exe", false);
        this.tst_Matches("file.cs", "tst_file.cs", false);
    }

    @Test
    public void Wildcard() {
        this.tst_Matches("*.cs", "file.cs", true);
        this.tst_Matches("file*", "file_valid.cs", true);
        this.tst_Matches("*.exe", "file.cs", false);
        this.tst_Matches("file*", "invalid_file.cs", false);
    }

    @Test
    public void DoubleWildcard() {
        this.tst_Matches("*cs*", "file.cs", true);
        this.tst_Matches("*cs*", "csFile.exe", true);
        this.tst_Matches("*cs*", "file.cs.exe", true);
        this.tst_Matches("*cs*", "file.exe", false);
    }

    @Test
    public void Compound() {
        this.tst_Matches("*.cs|*.exe", "file.cs", true);
        this.tst_Matches("*.cs|*.exe", "file.exe", true);
        this.tst_Matches("*.cs|*.exe", "file.dll", false);
        this.tst_Matches("*.cs|*.exe", "file.cs.exe.dll", false);
    }

    @Test
    public void Backslash() {
        this.tst_Matches("*\\bin\\*", "C:\\project\\bin\\", true);
        this.tst_Matches("*\\bin\\*", "C:\\project\\bin\\file.dll", true);
        this.tst_Matches("*\\bin\\*", "C:\\project\\binFiles\\", false);
    }

    @Test
    public void MixedCase() {
        this.tst_Matches("file.cs", "file.cs", true);
        this.tst_Matches("file.cs", "File.cS", true);
    }

    void tst_Matches(String regx, String raw, boolean expd) {
        RegxPatn_cls_ioMatch pattern = RegxPatn_cls_ioMatch_.parse(regx, false);
        boolean actl = pattern.Matches(raw);
        Tfds.Eq(expd, actl);
    }
}

