/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Tfds;
import gplx.core.texts.CharStream;
import org.junit.Before;
import org.junit.Test;

public class CharStream_tst {
    CharStream stream;

    @Before
    public void setup() {
        this.stream = CharStream.pos0_("abcdefgh");
    }

    @Test
    public void To_str() {
        Tfds.Eq(this.stream.To_str(), "abcdefgh");
    }

    @Test
    public void CurrentText() {
        this.stream.MoveNextBy(1);
        Tfds.Eq(this.stream.XtoStrAtCur(2), "bc");
        Tfds.Eq(this.stream.To_str(), "abcdefgh");
    }

    @Test
    public void CurrentText_outOfBounds() {
        this.stream.MoveNextBy(7);
        Tfds.Eq(this.stream.XtoStrAtCur(2), "h");
    }

    @Test
    public void Match() {
        this.stream.MoveNextBy(6);
        this.tst_Match(true, "g");
        this.tst_Match(false, "z");
        this.tst_Match(true, "gh");
        this.tst_Match(false, "gz");
        this.tst_Match(false, "ghi");
    }

    @Test
    public void AtBounds() {
        this.stream.Move_to(-1);
        this.tst_AtBounds(true, false, false);
        this.stream.Move_to(0);
        this.tst_AtBounds(false, true, false);
        this.stream.Move_to(this.stream.Len());
        this.tst_AtBounds(false, false, true);
    }

    void tst_Match(boolean expd, String text) {
        Tfds.Eq(expd, this.stream.Match(text));
    }

    void tst_AtBounds(boolean atBgn, boolean atMid, boolean atEnd) {
        Tfds.Eq(atBgn, this.stream.AtBgn());
        Tfds.Eq(atMid, this.stream.AtMid());
        Tfds.Eq(atEnd, this.stream.AtEnd());
    }
}

