/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.texts;

import gplx.Bry_;
import gplx.String_;

public class Base64Converter {
    private static final char[] ALPHABET = String_.XtoCharAry("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    private static int[] toInt = null;

    static void Init() {
        toInt = new int[128];
        int i = 0;
        while (i < ALPHABET.length) {
            Base64Converter.toInt[Base64Converter.ALPHABET[i]] = i;
            ++i;
        }
    }

    public static String EncodeString(String orig) {
        return Base64Converter.Encode(Bry_.new_u8(orig));
    }

    public static String Encode(byte[] buf) {
        if (toInt == null) {
            Base64Converter.Init();
        }
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
                ar[--a] = 61;
                break;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static String DecodeString(String orig) {
        return String_.new_u8(Base64Converter.Decode(orig));
    }

    public static byte[] Decode(String s) {
        if (toInt == null) {
            Base64Converter.Init();
        }
        int sLen = String_.Len(s);
        int delta = String_.Has_at_end(s, "==") ? 2 : (String_.Has_at_end(s, "=") ? 1 : 0);
        byte[] buffer = new byte[sLen * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        int i = 0;
        while (i < sLen) {
            int c0 = toInt[String_.CharAt(s, i)];
            int c1 = toInt[String_.CharAt(s, i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = toInt[String_.CharAt(s, i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = toInt[String_.CharAt(s, i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
            i += 4;
        }
        return buffer;
    }
}

