/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.tests;

import gplx.Datetime_now;
import gplx.Internal;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.Time_span_;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import gplx.core.tests.PerfLogTmr;

public class PerfLogMgr_fxt {
    List_adp entries = List_adp_.New();
    PerfLogTmr tmr = PerfLogTmr.new_();
    Io_url url = Io_url_.Empty;
    public static final PerfLogMgr_fxt Instance = new PerfLogMgr_fxt();

    public void Init(Io_url url, String text) {
        this.url = url;
        this.entries.Resize_bounds(1000);
        this.entries.Add(new PerfLogItm(0L, String.valueOf(text) + "|" + Datetime_now.Get().XtoStr_gplx()));
        this.tmr.Bgn();
    }

    public void Write(String text) {
        long milliseconds = this.tmr.ElapsedMilliseconds();
        this.entries.Add(new PerfLogItm(milliseconds, text));
        this.tmr.Bgn();
    }

    public void WriteFormat(String fmt, Object ... ary) {
        long milliseconds = this.tmr.ElapsedMilliseconds();
        String text = String_.Format(fmt, ary);
        this.entries.Add(new PerfLogItm(milliseconds, text));
        this.tmr.Bgn();
    }

    public void Flush() {
        String_bldr sb = String_bldr_.new_();
        for (Object itmObj : this.entries) {
            PerfLogItm itm = (PerfLogItm)itmObj;
            sb.Add(itm.To_str()).Add_char_crlf();
        }
        Io_mgr.Instance.AppendFilStr(this.url, sb.To_str());
        this.entries.Clear();
    }

    PerfLogMgr_fxt() {
    }

    class PerfLogItm {
        long milliseconds;
        String text;

        public String To_str() {
            String secondsStr = Time_span_.To_str(this.milliseconds, "0.000");
            secondsStr = String_.PadBgn(secondsStr, 7, "0");
            return String_.Concat(secondsStr, "|", this.text);
        }

        @Internal
        protected PerfLogItm(long milliseconds, String text) {
            this.milliseconds = milliseconds;
            this.text = text;
        }
    }
}

