/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.stores.xmls;

import gplx.String_;
import gplx.Tfds;
import gplx.core.stores.xmls.XmlDataWtr;
import org.junit.Before;
import org.junit.Test;

public class XmlDataWtr_tst {
    XmlDataWtr wtr;

    @Before
    public void setup() {
        this.wtr = XmlDataWtr.new_();
    }

    @Test
    public void WriteNodeBgn() {
        this.wtr.WriteNodeBgn("chapter");
        this.tst_XStr(this.wtr, "<chapter />", "\r\n");
    }

    @Test
    public void Attributes() {
        this.wtr.WriteNodeBgn("chapter");
        this.wtr.WriteData("id", 1);
        this.wtr.WriteData("name", "first");
        this.tst_XStr(this.wtr, "<chapter id=\"1\" name=\"first\" />", "\r\n");
    }

    @Test
    public void Subs() {
        this.wtr.WriteNodeBgn("title");
        this.wtr.WriteNodeBgn("chapters");
        this.wtr.WriteNodeBgn("chapter");
        this.tst_XStr(this.wtr, "<title>", "\r\n", "<chapters>", "\r\n", "<chapter />", "\r\n", "</chapters>", "\r\n", "</title>", "\r\n");
    }

    @Test
    public void Subs_Iterate() {
        this.wtr.WriteNodeBgn("titles");
        int title = 1;
        while (title <= 2) {
            this.wtr.WriteNodeBgn("title");
            this.wtr.WriteData("id", title);
            this.wtr.WriteNodeBgn("chapters");
            this.wtr.WriteNodeEnd();
            this.wtr.WriteNodeEnd();
            ++title;
        }
        this.wtr.WriteNodeEnd();
        this.tst_XStr(this.wtr, "<titles>", "\r\n", "<title id=\"1\">", "\r\n", "<chapters />", "\r\n", "</title>", "\r\n", "<title id=\"2\">", "\r\n", "<chapters />", "\r\n", "</title>", "\r\n", "</titles>", "\r\n");
    }

    @Test
    public void Peers() {
        this.wtr.WriteNodeBgn("title");
        this.wtr.WriteNodeBgn("chapters");
        this.wtr.WriteNodeEnd();
        this.wtr.WriteNodeBgn("audioStreams");
        this.tst_XStr(this.wtr, "<title>", "\r\n", "<chapters />", "\r\n", "<audioStreams />", "\r\n", "</title>", "\r\n");
    }

    @Test
    public void AtrsWithNesting() {
        this.wtr.WriteNodeBgn("title");
        this.wtr.WriteData("id", 1);
        this.wtr.WriteData("name", "first");
        this.wtr.WriteNodeBgn("chapters");
        this.tst_XStr(this.wtr, "<title id=\"1\" name=\"first\">", "\r\n", "<chapters />", "\r\n", "</title>", "\r\n");
    }

    void tst_XStr(XmlDataWtr wtr, String ... parts) {
        String expd = String_.Concat(parts);
        Tfds.Eq(expd, wtr.To_str());
    }
}

