/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.security;

import gplx.Bry_;
import gplx.Err_;
import gplx.String_;
import gplx.core.consoles.Console_adp;
import gplx.core.ios.streams.IoStream;
import gplx.core.progs.Gfo_prog_ui;
import gplx.core.security.Hash_algo;
import gplx.core.security.Hash_algo_utl_;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

abstract class Hash_algo_base
implements Hash_algo {
    private final MessageDigest md;
    private final byte[] trg_bry;
    private byte[] tmp_bfr;
    private final int tmp_bfr_len = 4096;

    public Hash_algo_base(MessageDigest md, int trg_bry_len) {
        this.md = md;
        this.trg_bry = new byte[trg_bry_len];
    }

    @Override
    public String Hash_bry_as_str(byte[] src) {
        return String_.new_a7(this.Hash_bry_as_bry(src));
    }

    @Override
    public byte[] Hash_bry_as_bry(byte[] src) {
        Hash_algo_utl_.Hash_bry(this.md, src, src.length, this.trg_bry);
        return Bry_.Copy(this.trg_bry);
    }

    @Override
    public String Hash_stream_as_str(Console_adp console, IoStream stream) {
        return String_.new_a7(this.Hash_stream_as_bry(console, stream));
    }

    public byte[] Hash_stream_as_bry(Console_adp console, IoStream stream) {
        if (this.tmp_bfr == null) {
            this.tmp_bfr = new byte[4096];
        }
        Hash_algo_utl_.Hash_stream(console, stream, this.md, this.tmp_bfr, 4096, this.trg_bry);
        return this.trg_bry;
    }

    @Override
    public byte[] Hash_stream_as_bry(Gfo_prog_ui prog_ui, IoStream stream) {
        if (this.tmp_bfr == null) {
            this.tmp_bfr = new byte[4096];
        }
        Hash_algo_utl_.Hash_stream(prog_ui, stream, this.md, this.tmp_bfr, 4096, this.trg_bry);
        return this.trg_bry;
    }

    protected static MessageDigest Get_message_digest(String key) {
        try {
            return MessageDigest.getInstance(key);
        }
        catch (NoSuchAlgorithmException e) {
            throw Err_.new_missing_key(key);
        }
    }
}

