/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.primitives;

import gplx.Tfds;
import gplx.core.primitives.EnmMgr;
import org.junit.Before;
import org.junit.Test;

public class EnmParser_tst {
    EnmMgr parser;

    @Before
    public void setup() {
        this.parser = EnmMgr.new_();
    }

    @Test
    public void Basic() {
        this.parser.BitRngEnd_(8);
        this.run_Reg(0, "zero");
        this.run_Reg(1, "one");
        this.run_Reg(2, "two");
        this.run_Reg(4, "four");
        this.run_Reg(8, "eight");
        this.tst_Convert("zero", 0);
        this.tst_Convert("one", 1);
        this.tst_Convert("eight", 8);
        this.tst_Convert("one+eight", 9);
    }

    @Test
    public void Keys() {
        this.parser.BitRngBgn_(65536).BitRngEnd_(262144);
        this.run_Reg(65, "a");
        this.run_Reg(65536, "shift");
        this.run_Reg(131072, "ctrl");
        this.run_Reg(262144, "alt");
        this.tst_Convert("a", 65);
        this.tst_Convert("shift+a", 65601);
        this.tst_Convert("ctrl+a", 131137);
        this.tst_Convert("shift+ctrl+a", 196673);
    }

    @Test
    public void Prefix() {
        this.parser.Prefix_("key.").BitRngBgn_(128).BitRngEnd_(128);
        this.run_Reg(65, "a");
        this.tst_Convert("key.a", 65);
    }

    void run_Reg(int i, String s) {
        this.parser.RegObj(i, s, "NULL");
    }

    void tst_Convert(String raw, int val) {
        int actlVal = this.parser.GetVal(raw);
        Tfds.Eq(val, actlVal);
        Tfds.Eq(raw, this.parser.GetStr(val));
    }
}

