/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.logs;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.DateAdp_;
import gplx.Int_;
import gplx.Object_;
import gplx.core.logs.Gfo_log_itm;
import gplx.core.logs.Gfo_log_itm_wtr;

public class Gfo_log_itm_wtr__csv
implements Gfo_log_itm_wtr {
    private static final byte[] Type__info = Bry_.new_a7("INFO");
    private static final byte[] Type__note = Bry_.new_a7("NOTE");
    private static final byte[] Type__warn = Bry_.new_a7("WARN");
    private String time_fmt = "yyyyMMdd_HHmmss.fff";

    @Override
    public void Write(Bry_bfr bfr, Gfo_log_itm itm) {
        bfr.Add_str_a7(Int_.To_str_pad_bgn_space((int)itm.Elapsed, 6)).Add_byte_pipe();
        bfr.Add_str_a7(DateAdp_.unixtime_utc_ms_(itm.Time).XtoStr_fmt(this.time_fmt)).Add_byte_pipe();
        byte[] type = null;
        switch (itm.Type) {
            case 3: {
                type = Type__info;
                break;
            }
            case 2: {
                type = Type__note;
                break;
            }
            case 1: {
                type = Type__warn;
            }
        }
        bfr.Add(type).Add_byte_pipe();
        this.Escape_str(bfr, itm.Msg);
        bfr.Add_byte_pipe();
        Object[] args = itm.Args;
        int args_len = args.length;
        int i = 0;
        while (i < args_len) {
            Object key = args[i];
            int val_idx = i + 1;
            String val = i < val_idx ? args[val_idx] : "<<<NULL>>>";
            this.Escape_str(bfr, Object_.Xto_str_strict_or_null_mark(key));
            bfr.Add_byte_eq();
            this.Escape_str(bfr, Object_.Xto_str_strict_or_null_mark(val));
            bfr.Add_byte_pipe();
            i += 2;
        }
        bfr.Add_byte_nl();
    }

    private void Escape_str(Bry_bfr bfr, String str) {
        byte[] bry = Bry_.new_u8(str);
        int len = bry.length;
        boolean dirty = false;
        int i = 0;
        while (i < len) {
            byte b = bry[i];
            byte escape_byte = 0;
            switch (b) {
                case 124: {
                    escape_byte = 112;
                    break;
                }
                case 10: {
                    escape_byte = 110;
                    break;
                }
                case 96: {
                    escape_byte = 96;
                    break;
                }
                default: {
                    if (!dirty) break;
                    bfr.Add_byte(b);
                }
            }
            if (escape_byte != 0) {
                if (!dirty) {
                    dirty = true;
                    bfr.Add_mid(bry, 0, i);
                }
                bfr.Add_byte((byte)96).Add_byte(escape_byte);
            }
            ++i;
        }
        if (!dirty) {
            bfr.Add(bry);
        }
    }
}

