/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.zips;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_split_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.List_adp;
import gplx.Long_;
import gplx.String_;
import gplx.core.ios.zips.Io_zip_decompress_cmd;
import gplx.core.progs.Gfo_prog_ui;

public abstract class Io_zip_decompress_cmd__base
implements Io_zip_decompress_cmd {
    private Io_url checkpoint_url;
    private String resume_name;
    private long resume_file;
    private long resume_item;
    private long checkpoint_interval = 0x2000000L;
    private long checkpoint_nxt = 0L;
    private String fail_msg;
    private final Bry_bfr bfr = Bry_bfr_.New();

    @Override
    public String Fail_msg() {
        return this.fail_msg;
    }

    @Override
    public abstract Io_zip_decompress_cmd Make_new();

    public long Prog_data_cur() {
        return this.resume_file;
    }

    @Override
    public byte Exec(Gfo_prog_ui prog_ui, Io_url src_fil, Io_url trg_dir, List_adp trg_fils) {
        this.Checkpoint__load_by_src_fil(src_fil);
        this.checkpoint_nxt = this.resume_file + this.checkpoint_interval;
        this.fail_msg = null;
        byte status = this.Exec_hook(prog_ui, src_fil, trg_dir, trg_fils, this.resume_name, this.resume_file, this.resume_item);
        switch (status) {
            case 4: 
            case 8: {
                this.Exec_cleanup();
                break;
            }
        }
        return status;
    }

    protected abstract byte Exec_hook(Gfo_prog_ui var1, Io_url var2, Io_url var3, List_adp var4, String var5, long var6, long var8);

    @Override
    public void Exec_cleanup() {
        if (this.checkpoint_url != null) {
            Io_mgr.Instance.DeleteFil(this.checkpoint_url);
        }
    }

    @Override
    public long Checkpoint__load_by_src_fil(Io_url src_fil) {
        this.checkpoint_url = src_fil.GenNewExt(".checkpoint");
        this.Checkpoint__load();
        return this.resume_file;
    }

    private void Checkpoint__load() {
        this.resume_name = null;
        this.resume_item = 0L;
        this.resume_file = 0L;
        byte[] data = Io_mgr.Instance.LoadFilBryOrNull(this.checkpoint_url);
        if (data == null) {
            return;
        }
        byte[][] lines = Bry_split_.Split_lines(data);
        if (lines.length != 3) {
            return;
        }
        this.resume_name = String_.new_u8(lines[0]);
        this.resume_file = Long_.parse_or(String_.new_a7(lines[1]), -1L);
        if (this.resume_file == -1L) {
            return;
        }
        this.resume_item = Long_.parse_or(String_.new_a7(lines[2]), -1L);
    }

    public boolean Checkpoint__save(String resume_name, long resume_file, long resume_item) {
        if (resume_file < this.checkpoint_nxt) {
            return false;
        }
        this.bfr.Add_str_u8(resume_name).Add_byte_nl();
        this.bfr.Add_long_variable(resume_file).Add_byte_nl();
        this.bfr.Add_long_variable(resume_item);
        Io_mgr.Instance.SaveFilBry(this.checkpoint_url, this.bfr.To_bry_and_clear());
        this.resume_name = resume_name;
        this.resume_file = resume_file;
        this.resume_item = resume_item;
        this.checkpoint_nxt += this.checkpoint_interval;
        return true;
    }
}

