/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.streams.wtrs;

import gplx.Bry_bfr;
import gplx.Err_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Virtual;
import gplx.core.ios.streams.Io_stream_wtr;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public abstract class Io_stream_wtr__base
implements Io_stream_wtr {
    private Io_url url;
    private Bry_bfr trg_bfr;
    private OutputStream zip_stream;
    private ByteArrayOutputStream mem_stream;

    @Override
    public abstract byte Tid();

    @Override
    public Io_url Url() {
        return this.url;
    }

    @Override
    public Io_stream_wtr Url_(Io_url v) {
        this.url = v;
        return this;
    }

    @Override
    public void Trg_bfr_(Bry_bfr v) {
        this.trg_bfr = v;
    }

    @Override
    public byte[] To_ary_and_clear() {
        return this.trg_bfr.To_bry_and_clear();
    }

    @Override
    @Virtual
    public Io_stream_wtr Open() {
        OutputStream bry_stream = null;
        if (this.trg_bfr == null) {
            if (!Io_mgr.Instance.ExistsFil(this.url)) {
                Io_mgr.Instance.SaveFilStr(this.url, "");
            }
            try {
                bry_stream = new FileOutputStream(this.url.Raw());
            }
            catch (Exception e) {
                throw Err_.new_exc(e, "io", "open failed", "url", this.url.Raw());
            }
        } else {
            bry_stream = this.mem_stream = new ByteArrayOutputStream();
        }
        this.zip_stream = this.Wrap_stream(bry_stream);
        return this;
    }

    @Override
    public void Write(byte[] bry, int bgn, int len) {
        try {
            this.zip_stream.write(bry, bgn, len);
        }
        catch (Exception e) {
            Err_.new_exc(e, "io", "write failed", "bgn", bgn, "len", len);
        }
    }

    @Override
    public void Flush() {
        if (this.trg_bfr != null) {
            try {
                this.zip_stream.close();
            }
            catch (Exception e) {
                throw Err_.new_exc(e, "io", "flush failed", new Object[0]);
            }
            this.trg_bfr.Add(this.mem_stream.toByteArray());
        }
    }

    @Override
    public void Rls() {
        try {
            if (this.zip_stream != null) {
                this.zip_stream.close();
            }
            if (this.mem_stream != null) {
                this.mem_stream.close();
            }
        }
        catch (Exception e) {
            throw Err_.new_exc(e, "io", "close failed", "url", this.url.Raw());
        }
    }

    @Virtual
    protected OutputStream Wrap_stream(OutputStream stream) {
        throw Err_.new_unimplemented();
    }
}

