/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.streams;

import gplx.Bry_bfr;
import gplx.Err_;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.core.ios.Io_download_fmt;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_wtr;
import gplx.core.ios.streams.wtrs.Io_stream_wtr__bzip2;
import gplx.core.ios.streams.wtrs.Io_stream_wtr__gzip;
import gplx.core.ios.streams.wtrs.Io_stream_wtr__raw;
import gplx.core.ios.streams.wtrs.Io_stream_wtr__xz;
import gplx.core.ios.streams.wtrs.Io_stream_wtr__zip;

public class Io_stream_wtr_ {
    public static Io_stream_wtr New__raw(Io_url url) {
        return new Io_stream_wtr__raw().Url_(url);
    }

    private static Io_stream_wtr New__zip(Io_url url) {
        return new Io_stream_wtr__zip().Url_(url);
    }

    private static Io_stream_wtr New__gzip(Io_url url) {
        return new Io_stream_wtr__gzip().Url_(url);
    }

    private static Io_stream_wtr New__bzip2(Io_url url) {
        return new Io_stream_wtr__bzip2().Url_(url);
    }

    public static Io_stream_wtr New_by_url(Io_url url) {
        String ext = url.Ext();
        if (String_.Eq(ext, ".zip")) {
            return Io_stream_wtr_.New__zip(url);
        }
        if (String_.Eq(ext, ".gz")) {
            return Io_stream_wtr_.New__gzip(url);
        }
        if (String_.Eq(ext, ".bz2")) {
            return Io_stream_wtr_.New__bzip2(url);
        }
        if (String_.Eq(ext, ".xz")) {
            return new Io_stream_wtr__xz().Url_(url);
        }
        return Io_stream_wtr_.New__raw(url);
    }

    public static Io_stream_wtr New_by_tid(byte v) {
        switch (v) {
            case 1: {
                return new Io_stream_wtr__raw();
            }
            case 2: {
                return new Io_stream_wtr__zip();
            }
            case 3: {
                return new Io_stream_wtr__gzip();
            }
            case 4: {
                return new Io_stream_wtr__bzip2();
            }
            case 5: {
                return new Io_stream_wtr__xz();
            }
        }
        throw Err_.new_unhandled(v);
    }

    public static Io_stream_wtr New_by_mem(Bry_bfr bfr, byte tid) {
        Io_stream_wtr wtr = Io_stream_wtr_.New_by_tid(tid).Url_(Io_url_.Empty);
        wtr.Trg_bfr_(bfr);
        return wtr;
    }

    public static void Save_rdr(Io_url url, Io_stream_rdr rdr, Io_download_fmt download_progress) {
        byte[] bry = new byte[4096];
        Io_stream_wtr wtr = Io_stream_wtr_.New_by_url(url);
        try {
            int read;
            wtr.Open();
            if (download_progress != Io_download_fmt.Null) {
                download_progress.Bgn(rdr.Len());
            }
            while ((read = rdr.Read(bry, 0, 4096)) >= 1) {
                if (download_progress != Io_download_fmt.Null) {
                    download_progress.Prog(read);
                }
                wtr.Write(bry, 0, read);
            }
            wtr.Flush();
            if (download_progress != Io_download_fmt.Null) {
                download_progress.Term();
            }
        }
        finally {
            wtr.Rls();
            rdr.Rls();
        }
    }
}

