/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios.streams;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.Virtual;
import gplx.core.ios.IoEngine_system;
import gplx.core.ios.streams.IoStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IoStream_base
implements IoStream {
    Io_url url = Io_url_.Empty;
    long pos;
    long length;
    Bry_bfr bfr = Bry_bfr_.Reset(16);
    RandomAccessFile under;
    boolean mode_is_append;
    byte mode;

    @Override
    @Virtual
    public Io_url Url() {
        return this.url;
    }

    @Override
    public void Transfer(IoStream trg, int bufferLength) {
        byte[] buffer = new byte[bufferLength];
        int read = -1;
        while (read != 0) {
            read = this.Read(buffer, 0, bufferLength);
            trg.Write(buffer, 0, read);
        }
        trg.Flush();
    }

    @Override
    public int ReadAry(byte[] ary) {
        return this.Read(ary, 0, ary.length);
    }

    @Override
    public void WriteAry(byte[] ary) {
        this.Write(ary, 0, ary.length);
    }

    @Override
    @Virtual
    public Object UnderRdr() {
        return this.under;
    }

    @Virtual
    public void UnderRdr_(Object v) {
        this.under = (RandomAccessFile)v;
    }

    @Override
    @Virtual
    public long Pos() {
        return this.pos;
    }

    @Override
    @Virtual
    public long Len() {
        return this.length;
    }

    @Override
    @Virtual
    public int Read(byte[] array, int offset, int count) {
        try {
            int rv = this.under.read(array, offset, count);
            return rv == -1 ? 0 : rv;
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "io", "file read failed", "url", this.url);
        }
    }

    @Override
    public long Seek(long seek_pos) {
        try {
            this.under.seek(seek_pos);
            this.pos = this.under.getFilePointer();
            return this.pos;
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "io", "seek failed", "url", this.url);
        }
    }

    @Override
    @Virtual
    public void Write(byte[] array, int offset, int count) {
        this.bfr.Add_mid(array, offset, offset + count);
        this.Flush();
    }

    @Override
    public void Write_and_flush(byte[] bry, int bgn, int end) {
        this.Flush();
        int buffer_len = 16384;
        byte[] buffer = new byte[buffer_len];
        int buffer_bgn = bgn;
        boolean loop = true;
        while (loop) {
            int buffer_end = buffer_bgn + buffer_len;
            if (buffer_end > end) {
                buffer_end = end;
                buffer_len = end - buffer_bgn;
                loop = false;
            }
            int i = 0;
            while (i < buffer_len) {
                buffer[i] = bry[i + buffer_bgn];
                ++i;
            }
            try {
                this.under.write(buffer, 0, buffer_len);
            }
            catch (IOException e) {
                throw Err_.new_exc(e, "io", "write failed", "url", this.url);
            }
            buffer_bgn = buffer_end;
        }
    }

    @Override
    @Virtual
    public void Flush() {
        try {
            if (this.mode_is_append) {
                this.under.seek(this.under.length());
            }
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "io", "seek failed", "url", this.url);
        }
        try {
            this.under.write(this.bfr.Bfr(), 0, this.bfr.Len());
        }
        catch (IOException e) {
            throw Err_.new_exc(e, "io", "write failed", "url", this.url);
        }
        this.bfr.Clear();
    }

    @Override
    @Virtual
    public void Rls() {
        IoEngine_system.Closeable_close((Closeable)this.under, this.url, true);
    }

    public static IoStream_base rdr_wrapper_() {
        return new IoStream_base();
    }

    public static IoStream_base new_(Io_url url, int mode) {
        IoStream_base rv = new IoStream_base();
        rv.url = url;
        rv.mode = (byte)mode;
        File file = new File(url.Xto_api());
        String ctor_mode = "";
        switch (mode) {
            case 2: {
                rv.mode_is_append = mode == 2;
                ctor_mode = "rws";
                break;
            }
            case 1: {
                ctor_mode = "rws";
                break;
            }
            case 0: {
                ctor_mode = "r";
            }
        }
        try {
            rv.under = new RandomAccessFile(file, ctor_mode);
        }
        catch (FileNotFoundException e) {
            throw Err_.new_exc(e, "io", "file open failed", "url", url);
        }
        if (mode == 1) {
            try {
                rv.under.setLength(0L);
            }
            catch (IOException e) {
                throw Err_.new_exc(e, "io", "file truncate failed", "url", url);
            }
        }
        rv.length = file.length();
        return rv;
    }

    public static IoStream_base new_(Object stream) {
        IoStream_base rv = new IoStream_base();
        rv.url = Io_url_.Empty;
        return rv;
    }
}

