/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Array_;
import gplx.Err_;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.core.ios.IoEngine_xrg_loadFilStr;
import gplx.core.ios.IoEngine_xrg_recycleFil;
import gplx.core.ios.IoEngine_xrg_saveFilStr;
import gplx.core.ios.IoEngine_xrg_xferFil;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;

public class IoRecycleBin {
    public static final IoRecycleBin Instance = new IoRecycleBin();

    public void Send(Io_url url) {
        this.Send_xrg(url).Exec();
    }

    public IoEngine_xrg_recycleFil Send_xrg(Io_url url) {
        return IoEngine_xrg_recycleFil.gplx_(url);
    }

    public void Recover(Io_url url) {
        String_bldr sb = String_bldr_.new_();
        List_adp list = this.Regy_search(url, sb);
        int listCount = list.Count();
        if (listCount > 1) {
            throw Err_.new_wo_type("found more than 1 url", "count", list.Count());
        }
        Io_url trgUrl = (Io_url)list.Get_at(0);
        IoEngine_xrg_xferFil.move_(url, trgUrl).ReadOnlyFails_(true).Overwrite_(false).Exec();
        IoEngine_xrg_saveFilStr.new_(this.FetchRegistryUrl(url), sb.To_str()).Exec();
    }

    public void Regy_add(IoEngine_xrg_recycleFil xrg) {
        Io_url url = xrg.RecycleUrl();
        Io_url regyUrl = this.FetchRegistryUrl(url);
        String text = String_.Concat_with_obj("|", url.NameAndExt_noDirSpr(), xrg.Url().GenRelUrl_orEmpty(url.OwnerRoot()), xrg.Uuid().To_str(), xrg.AppName(), xrg.Time());
        IoEngine_xrg_saveFilStr.new_(regyUrl, text).Append_().Exec();
    }

    public List_adp Regy_search(Io_url url, String_bldr sb) {
        List_adp list = List_adp_.New();
        Io_url regyUrl = this.FetchRegistryUrl(url);
        String[] lines = IoEngine_xrg_loadFilStr.new_(regyUrl).ExecAsStrAry();
        int linesLen = Array_.Len(lines);
        String nameAndExt = String.valueOf(url.NameAndExt_noDirSpr()) + "|";
        int i = linesLen;
        while (i > 0) {
            String line = lines[i - 1];
            if (String_.Has_at_bgn(line, nameAndExt)) {
                String[] terms = String_.Split(line, "|");
                Io_url origUrl = url.OwnerRoot().GenSubFil(terms[1]);
                list.Add(origUrl);
            } else {
                sb.Add_str_w_crlf(line);
            }
            --i;
        }
        return list;
    }

    Io_url FetchRegistryUrl(Io_url url) {
        String sourceApp = String_.GetStrBefore(url.NameAndExt_noDirSpr(), ";");
        return url.OwnerDir().GenSubFil_ary(sourceApp, ".recycle.csv");
    }

    IoRecycleBin() {
    }
}

