/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Internal;
import gplx.Io_url;
import gplx.New;
import gplx.String_;
import gplx.core.criterias.Criteria;
import gplx.core.criterias.Criteria_;
import gplx.core.ios.IoItmDir_;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.IoItmHash;
import gplx.core.ios.IoItmList;
import gplx.core.ios.IoItm_base;

public class IoItmDir
extends IoItm_base {
    private boolean exists = true;
    public static final int Type_Dir = 1;
    IoItmList subDirs;
    IoItmList subFils;

    public boolean Exists() {
        return this.exists;
    }

    public void Exists_set(boolean v) {
        this.exists = v;
    }

    @Override
    public int TypeId() {
        return 1;
    }

    @Override
    public boolean Type_dir() {
        return true;
    }

    @Override
    public boolean Type_fil() {
        return false;
    }

    @Override
    @New
    public IoItmDir XtnProps_set(String key, Object val) {
        return (IoItmDir)super.XtnProps_set(key, val);
    }

    public IoItmList SubDirs() {
        return this.subDirs;
    }

    public IoItmList SubFils() {
        return this.subFils;
    }

    public IoItmHash XtoIoItmList(Criteria crt) {
        IoItmHash rv = IoItmHash.list_(this.Url());
        this.XtoItmList_recur(rv, this, crt);
        return rv;
    }

    Io_url[] XtoIoUrlAry() {
        IoItmHash list = this.XtoIoItmList(Criteria_.All);
        int count = list.Count();
        Io_url[] rv = new Io_url[count];
        int i = 0;
        while (i < count) {
            rv[i] = list.Get_at(i).Url();
            ++i;
        }
        return rv;
    }

    public IoItmDir FetchDeepOrNull(Io_url findDirUrl) {
        String dirSpr = this.Url().Info().DirSpr();
        int dirSprLen = String_.Len(dirSpr);
        String currDirStr = this.Url().Raw();
        String findDirStr = findDirUrl.Raw();
        if (!String_.Has_at_bgn(findDirStr, currDirStr)) {
            return null;
        }
        String findName = String_.DelEnd(currDirStr, dirSprLen);
        IoItmDir curDir = this;
        do {
            int nextDirSprPos;
            if ((nextDirSprPos = String_.FindFwd(findDirStr = String_.DelBgn(findDirStr, String_.Len(findName) + dirSprLen), dirSpr)) == -1) {
                nextDirSprPos = String_.Len(findDirStr);
            }
            findName = String_.MidByLen(findDirStr, 0, nextDirSprPos);
            if (!String_.Eq(findDirStr, "")) continue;
            return curDir;
        } while ((curDir = IoItmDir_.as_(curDir.subDirs.Get_by(findName))) != null);
        return null;
    }

    void XtoItmList_recur(IoItmHash list, IoItmDir curDir, Criteria dirCrt) {
        for (Object subFilObj : curDir.SubFils()) {
            IoItmFil subFil = (IoItmFil)subFilObj;
            list.Add(subFil);
        }
        for (Object subDirObj : curDir.SubDirs()) {
            IoItmDir subDir = (IoItmDir)subDirObj;
            if (dirCrt.Matches(subDir)) {
                list.Add(subDir);
            }
            this.XtoItmList_recur(list, subDir, dirCrt);
        }
    }

    @Internal
    protected IoItmDir(boolean caseSensitive) {
        this.subDirs = IoItmList.new_(this, caseSensitive);
        this.subFils = IoItmList.new_(this, caseSensitive);
    }
}

