/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Io_url;
import gplx.Io_url_;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngineFxt;
import gplx.core.ios.IoEnginePool;
import gplx.core.ios.IoEngineUtl;
import gplx.core.ios.IoEngine_memory;
import gplx.core.ios.IoEngine_xrg_deleteFil;
import gplx.core.ios.IoEngine_xrg_saveFilStr;
import gplx.core.ios.IoEngine_xrg_xferFil;
import gplx.core.ios.IoUrlInfoRegy;
import gplx.core.ios.IoUrlInfo_;
import org.junit.Before;
import org.junit.Test;

public class IoEngine_stream_xfer_tst {
    IoEngineFxt fx = IoEngineFxt.new_();
    Io_url srcDir;
    Io_url trgDir;
    IoEngine srcEngine;
    IoEngine trgEngine;

    @Before
    public void setup() {
        this.srcEngine = IoEngine_memory.new_("mock1");
        this.trgEngine = IoEngine_memory.new_("mock2");
        IoEnginePool.Instance.Add_if_dupe_use_nth(this.srcEngine);
        IoEnginePool.Instance.Add_if_dupe_use_nth(this.trgEngine);
        IoUrlInfoRegy.Instance.Reg(IoUrlInfo_.mem_("mem1/", this.srcEngine.Key()));
        IoUrlInfoRegy.Instance.Reg(IoUrlInfo_.mem_("mem2/", this.trgEngine.Key()));
        this.srcDir = Io_url_.mem_dir_("mem1/dir");
        this.trgDir = Io_url_.mem_dir_("mem2/dir");
    }

    @Test
    public void TransferBetween() {
        Io_url srcPath = this.srcDir.GenSubFil("fil.txt");
        Io_url trgPath = this.trgDir.GenSubFil("fil.txt");
        this.tst_TransferStreams(this.srcEngine, srcPath, this.trgEngine, trgPath);
    }

    void tst_TransferStreams(IoEngine srcEngine, Io_url srcPath, IoEngine trgEngine, Io_url trgPath) {
        srcEngine.SaveFilText_api(IoEngine_xrg_saveFilStr.new_(srcPath, "test1"));
        trgEngine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(trgPath));
        this.fx.tst_ExistsPaths(true, srcPath);
        this.fx.tst_ExistsPaths(false, trgPath);
        IoEngineUtl utl = IoEngineUtl.new_();
        utl.BufferLength_set(4);
        utl.XferFil(srcEngine, IoEngine_xrg_xferFil.copy_(srcPath, trgPath));
        this.fx.tst_ExistsPaths(true, srcPath, trgPath);
        this.fx.tst_LoadFilStr(trgPath, "test1");
    }
}

