/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Bry_;
import gplx.DateAdp;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.Internal;
import gplx.Io_url;
import gplx.Io_url_;
import gplx.String_;
import gplx.core.ios.IoEnginePool;
import gplx.core.ios.IoEngineUtl;
import gplx.core.ios.IoEngine_base;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_deleteFil;
import gplx.core.ios.IoEngine_xrg_downloadFil;
import gplx.core.ios.IoEngine_xrg_loadFilStr;
import gplx.core.ios.IoEngine_xrg_openWrite;
import gplx.core.ios.IoEngine_xrg_queryDir;
import gplx.core.ios.IoEngine_xrg_saveFilStr;
import gplx.core.ios.IoEngine_xrg_xferDir;
import gplx.core.ios.IoEngine_xrg_xferFil;
import gplx.core.ios.IoErr;
import gplx.core.ios.IoItmAttrib;
import gplx.core.ios.IoItmDir;
import gplx.core.ios.IoItmDir_;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.IoItmFil_;
import gplx.core.ios.IoItmFil_mem;
import gplx.core.ios.IoItmHash;
import gplx.core.ios.streams.IoStream;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;

public class IoEngine_memory
extends IoEngine_base {
    private String key = "mem";
    IoItmHash dirs = IoItmHash.new_();
    IoEngineUtl utl = IoEngineUtl.new_();

    @Override
    public String Key() {
        return this.key;
    }

    @Override
    public boolean ExistsFil_api(Io_url url) {
        return this.FetchFil(url) != IoItmFil_mem.Null;
    }

    @Override
    public void DeleteFil_api(IoEngine_xrg_deleteFil args) {
        Io_url url = args.Url();
        IoItmDir dir = this.FetchDir(url.OwnerDir());
        if (dir == null) {
            return;
        }
        IoItmFil fil = IoItmFil_.as_(dir.SubFils().Get_by(url.NameAndExt()));
        if (fil != null && fil.ReadOnly() && args.ReadOnlyFails()) {
            throw IoErr.FileIsReadOnly(url);
        }
        dir.SubFils().Del(url);
    }

    void DeleteFil(Io_url url) {
        this.DeleteFil_api(IoEngine_xrg_deleteFil.new_(url));
    }

    @Override
    public void XferFil(IoEngine_xrg_xferFil args) {
        this.utl.XferFil(this, args);
    }

    @Override
    public void MoveFil(IoEngine_xrg_xferFil args) {
        Io_url src = args.Src();
        Io_url trg = args.Trg();
        boolean overwrite = args.Overwrite();
        if (String_.Eq(src.Xto_api(), trg.Xto_api())) {
            throw Err_.new_wo_type("move failed; src is same as trg", "raw", src.Raw());
        }
        this.CheckTransferArgs("move", src, trg, overwrite);
        if (overwrite) {
            this.DeleteFil(trg);
        }
        IoItmFil_mem curFil = this.FetchFil(src);
        curFil.Name_(trg.NameAndExt());
        this.AddFilToDir(trg.OwnerDir(), curFil);
        this.DeleteFil(src);
    }

    @Override
    public void CopyFil(IoEngine_xrg_xferFil args) {
        Io_url src = args.Src();
        Io_url trg = args.Trg();
        boolean overwrite = args.Overwrite();
        this.CheckTransferArgs("copy", src, trg, overwrite);
        if (overwrite) {
            this.DeleteFil(trg);
        }
        IoItmFil_mem srcFil = this.FetchFil(src);
        IoItmFil_mem curFil = srcFil.Clone();
        curFil.Name_(trg.NameAndExt());
        this.AddFilToDir(trg.OwnerDir(), curFil);
    }

    @Override
    public IoItmDir QueryDirDeep(IoEngine_xrg_queryDir args) {
        return this.utl.QueryDirDeep(this, args);
    }

    @Override
    public void UpdateFilAttrib(Io_url url, IoItmAttrib atr) {
        this.FetchFil(url).ReadOnly_(atr.ReadOnly());
    }

    @Override
    public void UpdateFilModifiedTime(Io_url url, DateAdp modified) {
        this.FetchFil(url).ModifiedTime_(modified);
    }

    @Override
    public IoItmFil QueryFil(Io_url url) {
        return this.FetchFil(url);
    }

    @Override
    public void SaveFilText_api(IoEngine_xrg_saveFilStr args) {
        IoItmFil fil;
        Io_url url = args.Url();
        IoItmDir dir = this.FetchDir(url.OwnerDir());
        if (dir != null && (fil = IoItmFil_.as_(dir.SubFils().Get_by(url.NameAndExt()))) != null && fil.ReadOnly()) {
            throw IoErr.FileIsReadOnly(url);
        }
        if (args.Append()) {
            this.AppendFilStr(args);
        } else {
            this.SaveFilStr(args.Url(), args.Text());
        }
    }

    @Override
    public boolean Truncate_fil(Io_url url, long size) {
        throw Err_.new_unimplemented();
    }

    @Override
    public String LoadFilStr(IoEngine_xrg_loadFilStr args) {
        return this.FetchFil(args.Url()).Text();
    }

    void SaveFilStr(Io_url url, String text) {
        DateAdp time = Datetime_now.Get();
        IoItmFil_mem fil = IoItmFil_mem.new_(url, String_.Len(text), time, text);
        this.AddFilToDir(url.OwnerDir(), fil);
    }

    void AppendFilStr(IoEngine_xrg_saveFilStr args) {
        Io_url url = args.Url();
        String text = args.Text();
        if (this.ExistsFil_api(url)) {
            IoItmFil_mem fil = this.FetchFil(url);
            fil.ModifiedTime_(Datetime_now.Get());
            fil.Text_set(String.valueOf(fil.Text()) + text);
        } else {
            this.SaveFilStr(args.Url(), args.Text());
        }
    }

    @Override
    public IoStream OpenStreamRead(Io_url url) {
        IoItmFil_mem fil = this.FetchFil(url);
        fil.Stream().Position_set(0);
        return fil.Stream();
    }

    @Override
    public IoStream OpenStreamWrite(IoEngine_xrg_openWrite args) {
        Io_url url = args.Url();
        IoItmFil_mem fil = this.FetchFil(url);
        if (fil == IoItmFil_mem.Null) {
            this.SaveFilStr(url, "");
            fil = this.FetchFil(url);
        } else if (args.Mode() == 1) {
            fil.Text_set("");
        }
        return fil.Stream();
    }

    @Override
    public boolean ExistsDir(Io_url url) {
        return this.FetchDir(url) != null;
    }

    @Override
    public void CreateDir(Io_url url) {
        IoItmDir dir = this.FetchDir(url);
        if (dir != null) {
            return;
        }
        dir = IoItmDir_.top_(url);
        this.dirs.Add(dir);
        IoItmDir ownerDir = this.FetchDir(url.OwnerDir());
        if (ownerDir == null && !url.OwnerDir().Eq(Io_url_.Empty)) {
            this.CreateDir(url.OwnerDir());
            ownerDir = this.FetchDir(url.OwnerDir());
        }
        if (ownerDir != null) {
            ownerDir.SubDirs().Add(dir);
        }
    }

    @Override
    public void DeleteDir(Io_url url) {
        this.FetchDir(url);
        this.dirs.Del(url);
        IoItmDir ownerDir = this.FetchDir(url.OwnerDir());
        if (ownerDir == null) {
            return;
        }
        ownerDir.SubDirs().Del(url);
    }

    @Override
    public void XferDir(IoEngine_xrg_xferDir args) {
        Io_url trg = args.Trg();
        this.utl.XferDir(this, args.Src(), IoEnginePool.Instance.Get_by(trg.Info().EngineKey()), trg, args);
    }

    @Override
    public void MoveDirDeep(IoEngine_xrg_xferDir args) {
        Io_url trg = args.Trg();
        this.utl.XferDir(this, args.Src(), IoEnginePool.Instance.Get_by(trg.Info().EngineKey()), trg, args);
    }

    @Override
    public void MoveDir(Io_url src, Io_url trg) {
        if (this.ExistsDir(trg)) {
            throw Err_.new_wo_type("trg already exists", "trg", trg);
        }
        IoItmDir dir = this.FetchDir(src);
        dir.Name_(trg.NameAndExt());
        for (Object filObj : dir.SubFils()) {
            IoItmFil fil = (IoItmFil)filObj;
            fil.OwnerDir_set(dir);
        }
        this.dirs.Add(dir);
        this.DeleteDir(src);
    }

    @Override
    public IoItmDir QueryDir(Io_url url) {
        IoItmDir dir = this.FetchDir(url);
        IoItmDir rv = IoItmDir_.top_(url);
        if (dir == null) {
            rv.Exists_set(false);
            return rv;
        }
        for (Object subDirObj : dir.SubDirs()) {
            IoItmDir subDir = (IoItmDir)subDirObj;
            rv.SubDirs().Add(IoItmDir_.scan_(subDir.Url()));
        }
        for (Object subFilObj : dir.SubFils()) {
            IoItmFil subFil = (IoItmFil)subFilObj;
            rv.SubFils().Add(subFil);
        }
        return rv;
    }

    @Override
    public void DeleteDirDeep(IoEngine_xrg_deleteDir args) {
        this.utl.DeleteDirDeep(this, args.Url(), args);
    }

    @Override
    public void CopyDir(Io_url src, Io_url trg) {
        IoEngine_xrg_xferDir.copy_(src, trg).Recur_().Exec();
    }

    void AddFilToDir(Io_url dirPath, IoItmFil fil) {
        IoItmDir dir = this.FetchDir(dirPath);
        if (dir == null) {
            this.CreateDir(dirPath);
            dir = this.FetchDir(dirPath);
        }
        dir.SubFils().Del(fil.Url());
        dir.SubFils().Add(fil);
    }

    IoItmDir FetchDir(Io_url url) {
        return IoItmDir_.as_(this.dirs.Get_by(url));
    }

    IoItmFil_mem FetchFil(Io_url url) {
        IoItmDir ownerDir = this.FetchDir(url.OwnerDir());
        if (ownerDir == null) {
            return IoItmFil_mem.Null;
        }
        IoItmFil_mem rv = IoItmFil_mem.as_(ownerDir.SubFils().Get_by(url.NameAndExt()));
        if (rv == null) {
            rv = IoItmFil_mem.Null;
        }
        return rv;
    }

    void CheckTransferArgs(String op, Io_url src, Io_url trg, boolean overwrite) {
        if (!this.ExistsFil_api(src)) {
            throw Err_.new_wo_type("src does not exist", "src", src);
        }
        if (this.ExistsFil_api(trg) && !overwrite) {
            throw Err_.new_invalid_op("trg already exists").Args_add("op", op, "overwrite", false, "src", src, "trg", trg);
        }
    }

    public void Clear() {
        this.dirs.Clear();
    }

    @Override
    public boolean DownloadFil(IoEngine_xrg_downloadFil xrg) {
        Io_url src = Io_url_.mem_fil_(xrg.Src());
        if (!this.ExistsFil_api(src)) {
            xrg.Rslt_((byte)2);
            return false;
        }
        this.XferFil(IoEngine_xrg_xferFil.copy_(src, xrg.Trg()).Overwrite_());
        return true;
    }

    @Override
    public Io_stream_rdr DownloadFil_as_rdr(IoEngine_xrg_downloadFil xrg) {
        Io_url src = Io_url_.mem_fil_(xrg.Src());
        if (!this.ExistsFil_api(src)) {
            xrg.Rslt_((byte)2);
            return Io_stream_rdr_.Noop;
        }
        byte[] bry = Bry_.new_u8(this.FetchFil(Io_url_.mem_fil_(xrg.Src())).Text());
        return Io_stream_rdr_.New__mem(bry);
    }

    @Internal
    protected static IoEngine_memory new_(String key) {
        IoEngine_memory rv = new IoEngine_memory();
        rv.key = key;
        return rv;
    }

    IoEngine_memory() {
    }
}

