/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.DateAdp_;
import gplx.Guid_adp_;
import gplx.List_adp;
import gplx.Tfds;
import gplx.Virtual;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngine_fil_basic_base;
import gplx.core.ios.IoEngine_system;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_recycleFil;
import gplx.core.ios.IoRecycleBin;
import org.junit.Test;

public class IoEngine_fil_basic_system_tst
extends IoEngine_fil_basic_base {
    @Override
    protected void setup_hook() {
        this.root = Tfds.RscDir.GenSubDir_nest("100_core", "ioEngineTest", "_temp");
        this.fil = this.root.GenSubFil("fil.txt");
        IoEngine_xrg_deleteDir.new_(this.fil.OwnerDir()).Recur_().ReadOnlyFails_off().Exec();
    }

    @Override
    protected IoEngine engine_() {
        return IoEngine_system.new_();
    }

    @Test
    public void ExistsFil_IgnoreDifferentCasing() {
        if (this.root.Info().CaseSensitive()) {
            return;
        }
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil);
        this.fx.tst_ExistsPaths(true, this.fil.OwnerDir().GenSubFil("FIL.txt"));
    }

    @Test
    @Virtual
    public void RecycleFil() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil);
        IoRecycleBin bin = IoRecycleBin.Instance;
        List_adp list = this.root.XtoNames();
        list.Del_at(0);
        IoEngine_xrg_recycleFil recycleXrg = bin.Send_xrg(this.fil).RootDirNames_(list).AppName_("gplx.test").Time_(DateAdp_.parse_gplx("20100102_115559123")).Uuid_(Guid_adp_.Parse("467ffb41-cdfe-402f-b22b-be855425784b"));
        recycleXrg.Exec();
        this.fx.tst_ExistsPaths(false, this.fil);
        this.fx.tst_ExistsPaths(true, recycleXrg.RecycleUrl());
        bin.Recover(recycleXrg.RecycleUrl());
        this.fx.tst_ExistsPaths(true, this.fil);
        this.fx.tst_ExistsPaths(false, recycleXrg.RecycleUrl());
    }

    @Override
    @Test
    public void DeleteFil_missing_pass() {
        super.DeleteFil_missing_pass();
    }

    @Override
    @Test
    public void DeleteFil_readOnly_pass() {
        super.DeleteFil_readOnly_pass();
    }

    @Override
    @Test
    public void SaveFilText_readOnlyFails() {
        super.SaveFilText_readOnlyFails();
    }
}

