/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.DateAdp_;
import gplx.Guid_adp_;
import gplx.Io_url_;
import gplx.List_adp;
import gplx.Tfds;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngine_;
import gplx.core.ios.IoEngine_fil_basic_base;
import gplx.core.ios.IoEngine_xrg_recycleFil;
import gplx.core.ios.IoItmDir;
import gplx.core.ios.IoItmFil_mem;
import gplx.core.ios.IoRecycleBin;
import org.junit.Test;

public class IoEngine_fil_basic_memory_tst
extends IoEngine_fil_basic_base {
    @Override
    protected IoEngine engine_() {
        return IoEngine_.Mem_init_();
    }

    @Override
    protected void setup_hook() {
        this.root = Io_url_.mem_dir_("mem");
        this.fil = this.root.GenSubFil_nest("root", "fil.txt");
    }

    @Override
    @Test
    public void OpenStreamRead() {
        super.OpenStreamRead();
    }

    @Override
    @Test
    public void SaveFilText_overwrite() {
        super.SaveFilText_overwrite();
        IoItmDir dirItm = this.fx.tst_ScanDir(this.fil.OwnerDir(), this.fil);
        IoItmFil_mem filItm = (IoItmFil_mem)dirItm.SubFils().Get_at(0);
        Tfds.Eq(filItm.Text(), "changed");
    }

    @Test
    public void RecycleFil() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil);
        IoRecycleBin bin = IoRecycleBin.Instance;
        List_adp list = Tfds.RscDir.XtoNames();
        list.Del_at(0);
        IoEngine_xrg_recycleFil recycleXrg = bin.Send_xrg(this.fil).RootDirNames_(list).AppName_("gplx.test").Time_(DateAdp_.parse_gplx("20100102_115559123")).Uuid_(Guid_adp_.Parse("467ffb41-cdfe-402f-b22b-be855425784b"));
        recycleXrg.Exec();
        this.fx.tst_ExistsPaths(false, this.fil);
        this.fx.tst_ExistsPaths(true, recycleXrg.RecycleUrl());
        bin.Recover(recycleXrg.RecycleUrl());
        this.fx.tst_ExistsPaths(true, this.fil);
        this.fx.tst_ExistsPaths(false, recycleXrg.RecycleUrl());
    }
}

