/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Bry_;
import gplx.DateAdp;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.Io_url;
import gplx.String_;
import gplx.Tfds;
import gplx.Virtual;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngineFxt;
import gplx.core.ios.IoEngine_xrg_deleteFil;
import gplx.core.ios.IoEngine_xrg_loadFilStr;
import gplx.core.ios.IoEngine_xrg_openWrite;
import gplx.core.ios.IoEngine_xrg_saveFilStr;
import gplx.core.ios.IoItmAttrib;
import gplx.core.ios.streams.IoStream;
import gplx.core.ios.streams.IoStream_;
import org.junit.Before;
import org.junit.Test;

public abstract class IoEngine_fil_basic_base {
    protected IoEngine engine;
    protected IoEngineFxt fx;
    protected Io_url fil;
    protected Io_url root;

    @Before
    public void setup() {
        this.engine = this.engine_();
        this.fx = IoEngineFxt.new_();
        this.setup_hook();
    }

    protected abstract IoEngine engine_();

    protected abstract void setup_hook();

    @Test
    @Virtual
    public void ExistsFil() {
        this.fx.tst_ExistsPaths(false, this.fil);
    }

    @Test
    @Virtual
    public void ExistsFil_deep() {
        this.fx.tst_ExistsPaths(false, this.root.GenSubFil_nest("dir1", "dir2", "fil1.txt"));
    }

    @Test
    @Virtual
    public void SaveFilStr() {
        this.fx.tst_ExistsPaths(false, this.fil, this.fil.OwnerDir());
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil, this.fil.OwnerDir());
    }

    @Test
    @Virtual
    public void SaveFilText_autoCreateOwnerDir() {
        this.fil = this.fil.OwnerDir().GenSubFil_nest("sub1", "fil1.txt");
        this.fx.tst_ExistsPaths(false, this.fil, this.fil.OwnerDir());
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil, this.fil.OwnerDir());
    }

    @Test
    @Virtual
    public void SaveFilText_overwrite() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil);
        this.fx.run_SaveFilText(this.fil, "changed");
        this.fx.tst_LoadFilStr(this.fil, "changed");
    }

    @Test
    @Virtual
    public void SaveFilText_append() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.engine.SaveFilText_api(IoEngine_xrg_saveFilStr.new_(this.fil, "appended").Append_());
        this.fx.tst_LoadFilStr(this.fil, "textappended");
    }

    @Test
    @Virtual
    public void SaveFilText_caseInsensitive() {
        if (this.root.Info().CaseSensitive()) {
            return;
        }
        Io_url lcase = this.root.GenSubFil_nest("dir", "fil.txt");
        Io_url ucase = this.root.GenSubFil_nest("DIR", "FIL.TXT");
        this.fx.run_SaveFilText(lcase, "text");
        this.fx.tst_ExistsPaths(true, lcase, ucase);
        this.fx.tst_LoadFilStr(lcase, "text");
        this.fx.tst_LoadFilStr(ucase, "text");
    }

    @Test
    @Virtual
    public void SaveFilText_readOnlyFails() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.engine.UpdateFilAttrib(this.fil, IoItmAttrib.readOnly_());
        try {
            this.fx.run_SaveFilText(this.fil, "changed");
        }
        catch (Exception exc) {
            this.fx.tst_LoadFilStr(this.fil, "text");
            Err_.Noop(exc);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    @Virtual
    public void LoadFilStr() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_LoadFilStr(this.fil, "text");
    }

    @Test
    @Virtual
    public void LoadFilStr_missingIgnored() {
        Tfds.Eq("", this.engine.LoadFilStr(IoEngine_xrg_loadFilStr.new_(this.fil).MissingIgnored_()));
    }

    @Test
    @Virtual
    public void UpdateFilAttrib() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_QueryFilReadOnly(this.fil, false);
        this.engine.UpdateFilAttrib(this.fil, IoItmAttrib.readOnly_());
        this.fx.tst_QueryFilReadOnly(this.fil, true);
    }

    @Test
    @Virtual
    public void DeleteFil() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_ExistsPaths(true, this.fil);
        this.engine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(this.fil));
        this.fx.tst_ExistsPaths(false, this.fil);
    }

    @Test
    @Virtual
    public void DeleteFil_missing_pass() {
        this.fil = this.root.GenSubFil("fileThatDoesntExist.txt");
        this.engine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(this.fil).MissingFails_off());
        this.fx.tst_ExistsPaths(false, this.fil);
    }

    @Test
    @Virtual
    public void DeleteFil_readOnly_fail() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.engine.UpdateFilAttrib(this.fil, IoItmAttrib.readOnly_());
        try {
            this.engine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(this.fil));
        }
        catch (Exception exc) {
            Err_.Noop(exc);
            this.fx.tst_ExistsPaths(true, this.fil);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    @Virtual
    public void DeleteFil_readOnly_pass() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.engine.UpdateFilAttrib(this.fil, IoItmAttrib.readOnly_());
        this.engine.DeleteFil_api(IoEngine_xrg_deleteFil.new_(this.fil).ReadOnlyFails_off());
        this.fx.tst_ExistsPaths(false, this.fil);
    }

    @Test
    @Virtual
    public void QueryFil_size() {
        this.fx.run_SaveFilText(this.fil, "text");
        this.fx.tst_QueryFil_size(this.fil, String_.Len("text"));
    }

    @Test
    @Virtual
    public void UpdateFilModifiedTime() {
        this.fx.run_SaveFilText(this.fil, "text");
        DateAdp time = Datetime_now.Dflt_add_min_(10);
        this.engine.UpdateFilModifiedTime(this.fil, time);
        this.fx.tst_QueryFil_modifiedTime(this.fil, time);
    }

    @Test
    @Virtual
    public void OpenStreamRead() {
        this.fx.run_SaveFilText(this.fil, "text");
        int textLen = String_.Len("text");
        byte[] buffer = new byte[textLen];
        IoStream stream = IoStream_.Null;
        try {
            stream = this.engine.OpenStreamRead(this.fil);
            stream.Read(buffer, 0, textLen);
        }
        finally {
            stream.Rls();
        }
        String actl = String_.new_u8(buffer);
        Tfds.Eq("text", actl);
    }

    @Test
    @Virtual
    public void OpenStreamWrite() {
        IoStream stream = IoEngine_xrg_openWrite.new_(this.fil).Exec();
        byte[] buffer = Bry_.new_u8("text");
        int textLen = String_.Len("text");
        stream.Write(buffer, 0, textLen);
        stream.Rls();
        this.fx.tst_LoadFilStr(this.fil, "text");
    }
}

