/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Internal;
import gplx.Io_url;
import gplx.Tfds;
import gplx.Virtual;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngineFxt;
import gplx.core.ios.IoEngine_xrg_deleteDir;
import gplx.core.ios.IoEngine_xrg_queryDir;
import gplx.core.ios.IoEngine_xrg_xferDir;
import org.junit.Before;
import org.junit.Test;

public abstract class IoEngine_dir_deep_base {
    protected IoEngine engine;
    protected Io_url fil;
    protected Io_url root;
    @Internal
    protected IoEngineFxt fx;
    protected Io_url src;
    protected Io_url src_dir0a;
    protected Io_url src_dir0a_dir0a;
    Io_url src_fil0a;
    Io_url src_dir0a_fil0a;
    protected Io_url trg;
    protected Io_url trg_dir0a;
    protected Io_url trg_dir0a_dir0a;
    Io_url trg_fil0a;
    Io_url trg_dir0a_fil0a;
    Io_url[] srcTree;
    Io_url[] trgTree;

    @Before
    public void setup() {
        this.engine = this.engine_();
        this.fx = IoEngineFxt.new_();
        this.setup_hook();
        this.setup_paths();
        this.setup_objs();
    }

    protected abstract IoEngine engine_();

    protected abstract void setup_hook();

    @Test
    @Virtual
    public void SearchDir() {
        Io_url[] expd = this.paths_(this.src_dir0a, this.src_fil0a, this.src_dir0a_dir0a, this.src_dir0a_fil0a);
        Io_url[] actl = IoEngine_xrg_queryDir.new_(this.src).Recur_().DirInclude_().ExecAsUrlAry();
        Tfds.Eq_ary(expd, actl);
    }

    @Test
    @Virtual
    public void MoveDirDeep() {
        this.fx.tst_ExistsPaths(true, this.srcTree);
        this.fx.tst_ExistsPaths(false, this.trgTree);
        this.engine.MoveDirDeep(IoEngine_xrg_xferDir.move_(this.src, this.trg).Recur_());
        this.fx.tst_ExistsPaths(false, this.srcTree);
        this.fx.tst_ExistsPaths(true, this.trgTree);
    }

    @Test
    @Virtual
    public void CopyDir() {
        this.fx.tst_ExistsPaths(true, this.srcTree);
        this.fx.tst_ExistsPaths(false, this.trgTree);
        this.engine.CopyDir(this.src, this.trg);
        this.fx.tst_ExistsPaths(true, this.srcTree);
        this.fx.tst_ExistsPaths(true, this.trgTree);
    }

    @Test
    @Virtual
    public void DeleteDir() {
        this.fx.tst_ExistsPaths(true, this.srcTree);
        this.engine.DeleteDirDeep(IoEngine_xrg_deleteDir.new_(this.src).Recur_());
        this.fx.tst_ExistsPaths(false, this.srcTree);
    }

    Io_url[] paths_(Io_url ... ary) {
        return ary;
    }

    protected void setup_paths() {
        this.src = this.root.GenSubDir_nest("src");
        this.src_dir0a = this.root.GenSubDir_nest("src", "dir0a");
        this.src_dir0a_dir0a = this.root.GenSubDir_nest("src", "dir0a", "dir0a");
        this.src_fil0a = this.root.GenSubFil_nest("src", "fil0a.txt");
        this.src_dir0a_fil0a = this.root.GenSubFil_nest("src", "dir0a", "fil0a.txt");
        this.trg = this.root.GenSubDir_nest("trg");
        this.trg_dir0a = this.root.GenSubDir_nest("trg", "dir0a");
        this.trg_dir0a_dir0a = this.root.GenSubDir_nest("trg", "dir0a", "dir0a");
        this.trg_fil0a = this.root.GenSubFil_nest("trg", "fil0a.txt");
        this.trg_dir0a_fil0a = this.root.GenSubFil_nest("trg", "dir0a", "fil0a.txt");
        this.srcTree = new Io_url[]{this.src, this.src_dir0a, this.src_dir0a_dir0a, this.src_fil0a, this.src_dir0a_fil0a};
        this.trgTree = new Io_url[]{this.trg, this.trg_dir0a, this.trg_dir0a_dir0a, this.trg_fil0a, this.trg_dir0a_fil0a};
    }

    void setup_objs() {
        this.fx.run_SaveFilText(this.src_fil0a, "src_fil0a");
        this.fx.run_SaveFilText(this.src_dir0a_fil0a, "src_dir0a_fil0a");
        this.fx.tst_ExistsPaths(true, this.src_fil0a);
        this.engine.CreateDir(this.src_dir0a_dir0a);
    }
}

