/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.ios;

import gplx.Internal;
import gplx.Io_url;
import gplx.Virtual;
import gplx.core.ios.IoEngine;
import gplx.core.ios.IoEngineFxt;
import org.junit.Before;
import org.junit.Test;

public abstract class IoEngine_dir_basic_base {
    protected IoEngine engine;
    @Internal
    protected IoEngineFxt fx;
    protected Io_url fil;
    protected Io_url root;

    @Before
    public void setup() {
        this.engine = this.engine_();
        this.fx = IoEngineFxt.new_();
        this.setup_hook();
    }

    protected abstract IoEngine engine_();

    protected abstract void setup_hook();

    @Test
    @Virtual
    public void CreateDir() {
        this.fx.tst_ExistsPaths(false, this.root);
        this.engine.CreateDir(this.root);
        this.fx.tst_ExistsPaths(true, this.root);
    }

    @Test
    public void DeleteDir() {
        this.engine.CreateDir(this.root);
        this.fx.tst_ExistsPaths(true, this.root);
        this.engine.DeleteDir(this.root);
        this.fx.tst_ExistsPaths(false, this.root);
    }

    @Test
    public void CreateDir_createAllOwners() {
        Io_url subDir = this.root.GenSubDir_nest("sub1");
        this.fx.tst_ExistsPaths(false, subDir, subDir.OwnerDir());
        this.engine.CreateDir(subDir);
        this.fx.tst_ExistsPaths(true, subDir, subDir.OwnerDir());
    }

    @Test
    public void DeleteDir_missing_pass() {
        this.engine.DeleteDir(this.root);
    }

    @Test
    @Virtual
    public void ScanDir() {
        Io_url fil = this.root.GenSubFil("fil1.txt");
        this.fx.run_SaveFilText(fil, "test");
        Io_url dir1 = this.root.GenSubDir_nest("dir1");
        this.engine.CreateDir(dir1);
        Io_url dir1_1 = dir1.GenSubDir_nest("dir1_1");
        this.engine.CreateDir(dir1_1);
        this.fx.tst_ScanDir(this.root, dir1, fil);
    }

    @Test
    public void MoveDir() {
        Io_url src = this.root.GenSubDir_nest("src");
        Io_url trg = this.root.GenSubDir_nest("trg");
        this.engine.CreateDir(src);
        this.fx.tst_ExistsPaths(true, src);
        this.fx.tst_ExistsPaths(false, trg);
        this.engine.MoveDir(src, trg);
        this.fx.tst_ExistsPaths(false, src);
        this.fx.tst_ExistsPaths(true, trg);
    }

    @Test
    @Virtual
    public void CopyDir() {
        Io_url src = this.root.GenSubDir_nest("src");
        Io_url trg = this.root.GenSubDir_nest("trg");
        this.engine.CreateDir(src);
        this.fx.tst_ExistsPaths(true, src);
        this.fx.tst_ExistsPaths(false, trg);
        this.engine.CopyDir(src, trg);
        this.fx.tst_ExistsPaths(true, src, trg);
    }
}

