/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.intls;

import gplx.Bry_;
import gplx.Err_;
import gplx.core.encoders.Hex_utl_;
import gplx.core.primitives.Int_obj_ref;

public class Utf16_ {
    public static int Surrogate_merge(int hi, int lo) {
        return 65536 + (hi - 55296) * 1024 + (lo - 56320);
    }

    public static void Surrogate_split(int v, Int_obj_ref hi, Int_obj_ref lo) {
        hi.Val_((v - 65536) / 1024 + 55296);
        lo.Val_((v - 65536) % 1024 + 56320);
    }

    public static int Decode_to_int(byte[] ary, int pos) {
        byte b0 = ary[pos];
        if ((b0 & 0x80) == 0) {
            return b0;
        }
        if ((b0 & 0xE0) == 192) {
            return (b0 & 0x1F) << 6 | ary[pos + 1] & 0x3F;
        }
        if ((b0 & 0xF0) == 224) {
            return (b0 & 0xF) << 12 | (ary[pos + 1] & 0x3F) << 6 | ary[pos + 2] & 0x3F;
        }
        if ((b0 & 0xF8) == 240) {
            return (b0 & 7) << 18 | (ary[pos + 1] & 0x3F) << 12 | (ary[pos + 2] & 0x3F) << 6 | ary[pos + 3] & 0x3F;
        }
        throw Err_.new_wo_type("invalid utf8 byte", "byte", b0);
    }

    public static byte[] Encode_hex_to_bry(String raw) {
        return Utf16_.Encode_hex_to_bry(Bry_.new_a7(raw));
    }

    public static byte[] Encode_hex_to_bry(byte[] raw) {
        if (raw == null) {
            return null;
        }
        int int_val = Hex_utl_.Parse_or(raw, Integer.MIN_VALUE);
        return int_val == Integer.MIN_VALUE ? null : Utf16_.Encode_int_to_bry(int_val);
    }

    public static byte[] Encode_int_to_bry(int c) {
        int bry_len = Utf16_.Len_by_int(c);
        byte[] bry = new byte[bry_len];
        Utf16_.Encode_int(c, bry, 0);
        return bry;
    }

    public static int Encode_char(int c, char[] c_ary, int c_pos, byte[] b_ary, int b_pos) {
        if (c > -1 && c < 128) {
            b_ary[b_pos] = (byte)c;
            return 1;
        }
        if (c < 2048) {
            b_ary[b_pos] = (byte)(0xC0 | c >> 6);
            b_ary[++b_pos] = (byte)(0x80 | c & 0x3F);
            return 1;
        }
        if (c > 55295 && c < 56320) {
            if (c_pos >= c_ary.length) {
                throw Err_.new_wo_type("incomplete surrogate pair at end of String", "char", c);
            }
            char nxt_char = c_ary[c_pos + 1];
            int v = Utf16_.Surrogate_merge(c, nxt_char);
            b_ary[b_pos] = (byte)(0xF0 | v >> 18);
            b_ary[++b_pos] = (byte)(0x80 | v >> 12 & 0x3F);
            b_ary[++b_pos] = (byte)(0x80 | v >> 6 & 0x3F);
            b_ary[++b_pos] = (byte)(0x80 | v & 0x3F);
            return 2;
        }
        b_ary[b_pos] = (byte)(0xE0 | c >> 12);
        b_ary[++b_pos] = (byte)(0x80 | c >> 6 & 0x3F);
        b_ary[++b_pos] = (byte)(0x80 | c & 0x3F);
        return 1;
    }

    public static int Encode_int(int c, byte[] src, int pos) {
        if (c > -1 && c < 128) {
            src[pos] = (byte)c;
            return 1;
        }
        if (c < 2048) {
            src[pos] = (byte)(0xC0 | c >> 6);
            src[++pos] = (byte)(0x80 | c & 0x3F);
            return 2;
        }
        if (c < 65536) {
            src[pos] = (byte)(0xE0 | c >> 12);
            src[++pos] = (byte)(0x80 | c >> 6 & 0x3F);
            src[++pos] = (byte)(0x80 | c & 0x3F);
            return 3;
        }
        if (c < 0x200000) {
            src[pos] = (byte)(0xF0 | c >> 18);
            src[++pos] = (byte)(0x80 | c >> 12 & 0x3F);
            src[++pos] = (byte)(0x80 | c >> 6 & 0x3F);
            src[++pos] = (byte)(0x80 | c & 0x3F);
            return 4;
        }
        throw Err_.new_wo_type("UTF-16 int must be between 0 and 2097152", "char", c);
    }

    private static int Len_by_int(int c) {
        if (c > -1 && c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c < 65536) {
            return 3;
        }
        if (c < 0x200000) {
            return 4;
        }
        throw Err_.new_wo_type("UTF-16 int must be between 0 and 2097152", "char", c);
    }

    public static int Len_by_char(int c) {
        if (c > -1 && c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c > 55295 && c < 56320) {
            return 4;
        }
        if (c < 65536) {
            return 3;
        }
        throw Err_.new_wo_type("UTF-16 int must be between 0 and 65536", "char", c);
    }
}

