/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.envs;

import gplx.Char_;
import gplx.Err_;
import gplx.String_;

public class Op_sys {
    private final byte tid;
    private final byte sub_tid;
    private String os_name;
    private final byte bitness;
    private final String nl_str;
    private final String fsys_dir_spr_str;
    private final byte fsys_dir_spr_byte;
    private final boolean fsys_case_match;
    public static final byte Tid_nil = 0;
    public static final byte Tid_wnt = 1;
    public static final byte Tid_lnx = 2;
    public static final byte Tid_osx = 3;
    public static final byte Tid_drd = 4;
    public static final byte Tid_arm = 5;
    public static final byte Sub_tid_unknown = 0;
    public static final byte Sub_tid_win_xp = 1;
    public static final byte Sub_tid_win_7 = 2;
    public static final byte Sub_tid_win_8 = 3;
    public static final byte Bitness_32 = 1;
    public static final byte Bitness_64 = 2;
    public static final char Nl_char_lnx = '\n';
    public static final byte Dir_spr__lnx = 47;
    public static final byte Dir_spr__wnt = 92;
    public static final Op_sys Lnx = Op_sys.new_unx_flavor_((byte)2, "linux", (byte)1);
    public static final Op_sys Osx = Op_sys.new_unx_flavor_((byte)3, "macosx", (byte)1);
    public static final Op_sys Drd = Op_sys.new_unx_flavor_((byte)4, "android", (byte)1);
    public static final Op_sys Wnt = Op_sys.new_wnt_((byte)0, (byte)1);
    static Op_sys cur_op_sys = Op_sys.new_auto_identify_();
    static final String GRP_KEY = "gplx.op_sys";

    Op_sys(byte tid, byte sub_tid, String os_name, byte bitness, String nl_str, byte fsys_dir_spr_byte, boolean fsys_case_match) {
        this.tid = tid;
        this.sub_tid = sub_tid;
        this.os_name = os_name;
        this.bitness = bitness;
        this.nl_str = nl_str;
        this.fsys_dir_spr_byte = fsys_dir_spr_byte;
        this.fsys_dir_spr_str = Char_.To_str((char)fsys_dir_spr_byte);
        this.fsys_case_match = fsys_case_match;
    }

    public byte Tid() {
        return this.tid;
    }

    public byte Sub_tid() {
        return this.sub_tid;
    }

    public String Os_name() {
        return this.os_name;
    }

    public byte Bitness() {
        return this.bitness;
    }

    public String Bitness_str() {
        return this.bitness == 1 ? "32" : "64";
    }

    public String Nl_str() {
        return this.nl_str;
    }

    public String Fsys_dir_spr_str() {
        return this.fsys_dir_spr_str;
    }

    public byte Fsys_dir_spr_byte() {
        return this.fsys_dir_spr_byte;
    }

    public String Fsys_http_frag_to_url_str(String raw) {
        return this.fsys_dir_spr_byte == 47 ? raw : String_.Replace(raw, Lnx.Fsys_dir_spr_str(), this.fsys_dir_spr_str);
    }

    public boolean Fsys_case_match() {
        return this.fsys_case_match;
    }

    public String Fsys_case_match_str(String s) {
        return String_.CaseNormalize(this.fsys_case_match, s);
    }

    public boolean Tid_is_wnt() {
        return this.tid == 1;
    }

    public boolean Tid_is_lnx() {
        return this.tid == 2;
    }

    public boolean Tid_is_osx() {
        return this.tid == 3;
    }

    public boolean Tid_is_drd() {
        return this.tid == 4;
    }

    public String To_str() {
        return String.valueOf(this.os_name) + this.Bitness_str();
    }

    public static Op_sys Cur() {
        return cur_op_sys;
    }

    public static String Fsys_path_to_lnx(String v) {
        return cur_op_sys.Tid_is_wnt() ? String_.Replace(v, Op_sys.Wnt.fsys_dir_spr_str, Op_sys.Lnx.fsys_dir_spr_str) : v;
    }

    public static String Fsys_path_to_wnt(String v) {
        return cur_op_sys.Tid_is_wnt() ? String_.Replace(v, Op_sys.Lnx.fsys_dir_spr_str, Op_sys.Wnt.fsys_dir_spr_str) : v;
    }

    private static Op_sys new_wnt_(byte bitness, byte sub_tid) {
        return new Op_sys(1, sub_tid, "windows", bitness, "\r\n", 92, false);
    }

    private static Op_sys new_unx_flavor_(byte tid, String os_name, byte bitness) {
        return new Op_sys(tid, 0, os_name, bitness, "\n", 47, true);
    }

    public static void Cur_(int tid) {
        switch (tid) {
            case 1: {
                cur_op_sys = Wnt;
                break;
            }
            case 2: {
                cur_op_sys = Lnx;
                break;
            }
            case 3: {
                cur_op_sys = Osx;
                break;
            }
            case 4: {
                cur_op_sys = Drd;
                break;
            }
            default: {
                throw Err_.new_unhandled_default(tid);
            }
        }
    }

    static Op_sys new_auto_identify_() {
        String os_name = "";
        try {
            String bitness_str = System.getProperty("sun.arch.data.model");
            if (bitness_str == null) {
                return Drd;
            }
            bitness_str = bitness_str.toLowerCase();
            byte bitness_byte = 1;
            if (String_.Eq(bitness_str, "32")) {
                bitness_byte = 1;
            } else if (String_.Eq(bitness_str, "64")) {
                bitness_byte = 2;
            } else {
                throw Err_.new_wo_type("unknown bitness; expecting 32 or 64; System.getProperty(\"bit.level\")", "val", bitness_str);
            }
            os_name = System.getProperty("os.name").toLowerCase();
            String os_arch = System.getProperty("os.arch").toLowerCase();
            if (String_.Eq(os_arch, "arm")) {
                return Op_sys.new_unx_flavor_((byte)5, os_name, bitness_byte);
            }
            if (String_.Has_at_bgn(os_name, "win")) {
                String os_version = System.getProperty("os.version").toLowerCase();
                int sub_tid = 0;
                if (String_.Eq(os_name, "windows xp") && String_.Eq(os_version, "5.1")) {
                    sub_tid = 1;
                } else if (String_.Eq(os_name, "windows 7") && String_.Eq(os_version, "6.1")) {
                    sub_tid = 2;
                } else if (String_.Eq(os_name, "windows 8")) {
                    sub_tid = 3;
                }
                return Op_sys.new_wnt_(bitness_byte, (byte)sub_tid);
            }
            if (String_.Eq(os_name, "linux")) {
                return Op_sys.new_unx_flavor_((byte)2, os_name, bitness_byte);
            }
            if (String_.Has_at_bgn(os_name, "mac")) {
                return Op_sys.new_unx_flavor_((byte)3, os_name, bitness_byte);
            }
            throw Err_.new_wo_type("unknown os_name; expecting windows, linux, mac; System.getProperty(\"os.name\")", "val", os_name);
        }
        catch (Exception exc) {
            Op_sys.Drd.os_name = os_name;
            return Drd;
        }
    }

    public static void Cur_is_drd_() {
        cur_op_sys = Drd;
    }
}

