/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.criterias;

import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.core.criterias.Criteria;
import gplx.core.criterias.CriteriaFxt;
import gplx.core.criterias.Criteria_;
import org.junit.Test;

public class Criteria_tst {
    CriteriaFxt fx = new CriteriaFxt();
    DateAdp date = DateAdp_.parse_gplx("2001-01-01");

    @Test
    public void Equal() {
        Criteria crt = Criteria_.eq_(true);
        this.fx.tst_Matches(crt, true);
        this.fx.tst_MatchesNot(crt, false);
        this.fx.tst_MatchesFail(crt, "true");
        this.fx.tst_Matches(Criteria_.eq_(1), 1);
        this.fx.tst_Matches(Criteria_.eq_("equal"), "equal");
        this.fx.tst_Matches(Criteria_.eq_(this.date), this.date);
    }

    @Test
    public void Not() {
        Criteria crt = Criteria_.eqn_(true);
        this.fx.tst_Matches(crt, false);
        this.fx.tst_MatchesNot(crt, true);
        this.fx.tst_MatchesFail(crt, "false");
        this.fx.tst_Matches(Criteria_.eqn_(1), -1);
        this.fx.tst_Matches(Criteria_.eqn_("equal"), "not equal");
        this.fx.tst_Matches(Criteria_.eqn_(this.date), this.date.Add_minute(1));
    }

    @Test
    public void MoreThan() {
        Criteria crt = Criteria_.mt_(Integer.valueOf(0));
        this.fx.tst_Matches(crt, 1, 2);
        this.fx.tst_MatchesNot(crt, 0, -1);
        this.fx.tst_MatchesFail(crt, "1");
        this.fx.tst_Matches(Criteria_.mt_(Integer.valueOf(0)), 1);
        this.fx.tst_Matches(Criteria_.mt_((Comparable)((Object)"a")), "b");
        this.fx.tst_Matches(Criteria_.mt_(this.date), this.date.Add_minute(1));
        this.fx.tst_Matches(Criteria_.mt_(Boolean.valueOf(false)), true);
    }

    @Test
    public void MoreThanEq() {
        Criteria crt = Criteria_.mte_(Integer.valueOf(0));
        this.fx.tst_Matches(crt, 0);
    }

    @Test
    public void Less() {
        Criteria crt = Criteria_.lt_(Integer.valueOf(0));
        this.fx.tst_Matches(crt, -1, -2);
        this.fx.tst_MatchesNot(crt, 0, 1);
        this.fx.tst_MatchesFail(crt, "-1");
    }

    @Test
    public void LessEq() {
        Criteria crt = Criteria_.lte_(Integer.valueOf(0));
        this.fx.tst_Matches(crt, 0);
    }

    @Test
    public void Between() {
        Criteria crt = Criteria_.between_(Integer.valueOf(-1), Integer.valueOf(1));
        this.fx.tst_Matches(crt, 0, 1, -1);
        this.fx.tst_MatchesNot(crt, -2, 2);
        this.fx.tst_MatchesFail(crt, "0");
        this.fx.tst_Matches(Criteria_.between_(Integer.valueOf(1), Integer.valueOf(-1)), 0);
        this.fx.tst_Matches(Criteria_.between_((Comparable)((Object)"a"), (Comparable)((Object)"c")), "b");
    }

    @Test
    public void In() {
        Criteria crt = Criteria_.in_(0, 1, 2);
        this.fx.tst_Matches(crt, 0, 1, 2);
        this.fx.tst_MatchesNot(crt, 3, -1);
        this.fx.tst_MatchesFail(crt, "0");
    }
}

