/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Bry_;
import gplx.Tfds;
import gplx.core.btries.Btrie_slim_mgr;
import org.junit.Before;
import org.junit.Test;

public class Btrie_slim_mgr_tst {
    private Btrie_slim_mgr trie;

    @Before
    public void init() {
    }

    private void ini_setup1() {
        this.trie = Btrie_slim_mgr.cs();
        this.run_Add("a", 1);
        this.run_Add("abc", 123);
    }

    @Test
    public void Get_by() {
        this.ini_setup1();
        this.tst_MatchAtCur("a", 1);
        this.tst_MatchAtCur("abc", 123);
        this.tst_MatchAtCur("ab", 1);
        this.tst_MatchAtCur("abcde", 123);
        this.tst_MatchAtCur(" a", null);
    }

    @Test
    public void Bos() {
        this.ini_setup1();
        this.tst_Match("bc", (byte)97, -1, 123);
    }

    @Test
    public void Match_exact() {
        this.ini_setup1();
        this.tst_MatchAtCurExact("a", 1);
        this.tst_MatchAtCurExact("ab", null);
        this.tst_MatchAtCurExact("abc", 123);
    }

    private void ini_setup2() {
        this.trie = Btrie_slim_mgr.cs();
        this.run_Add("a", 1);
        this.run_Add("b", 2);
    }

    @Test
    public void Match_2() {
        this.ini_setup2();
        this.tst_MatchAtCur("a", 1);
        this.tst_MatchAtCur("b", 2);
    }

    private void ini_setup_caseAny() {
        this.trie = Btrie_slim_mgr.ci_a7();
        this.run_Add("a", 1);
        this.run_Add("b", 2);
    }

    @Test
    public void CaseAny() {
        this.ini_setup_caseAny();
        this.tst_MatchAtCur("a", 1);
        this.tst_MatchAtCur("A", 1);
    }

    @Test
    public void Del() {
        this.ini_setup1();
        this.trie.Del(Bry_.new_a7("a"));
        this.tst_MatchAtCur("a", null);
        this.tst_MatchAtCur("abc", 123);
        this.trie.Del(Bry_.new_a7("abc"));
        this.tst_MatchAtCur("abc", null);
    }

    private void run_Add(String k, int val) {
        this.trie.Add_obj(Bry_.new_a7(k), (Object)val);
    }

    private void tst_Match(String srcStr, byte b, int bgn_pos, int expd) {
        byte[] src = Bry_.new_a7(srcStr);
        Object actl = this.trie.Match_bgn_w_byte(b, src, bgn_pos, src.length);
        Tfds.Eq(expd, actl);
    }

    private void tst_MatchAtCur(String srcStr, Object expd) {
        byte[] src = Bry_.new_a7(srcStr);
        Object actl = this.trie.Match_bgn_w_byte(src[0], src, 0, src.length);
        Tfds.Eq(expd, actl);
    }

    private void tst_MatchAtCurExact(String srcStr, Object expd) {
        byte[] src = Bry_.new_a7(srcStr);
        Object actl = this.trie.Match_exact(src, 0, src.length);
        Tfds.Eq(expd, actl);
    }
}

