/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Err_;
import gplx.String_;
import gplx.core.btries.Btrie_itm_stub;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.ByteTrieItm_fast;
import gplx.core.primitives.Byte_obj_val;

public class Btrie_fast_mgr {
    private ByteTrieItm_fast root;
    private int match_pos;

    public boolean CaseAny() {
        return this.root.CaseAny();
    }

    public Btrie_fast_mgr CaseAny_(boolean v) {
        this.root.CaseAny_(v);
        return this;
    }

    public int Match_pos() {
        return this.match_pos;
    }

    public Object Match_at(Btrie_rv rv, byte[] src, int bgn_pos, int end_pos) {
        return this.Match_at_w_b0(rv, src[bgn_pos], src, bgn_pos, end_pos);
    }

    public Object Match_at_w_b0(Btrie_rv rv, byte b, byte[] src, int bgn_pos, int src_end) {
        Object rv_obj = null;
        int rv_pos = bgn_pos;
        ByteTrieItm_fast nxt = this.root.Ary_find(b);
        if (nxt == null) {
            rv.Init(rv_pos, rv_obj);
            return rv_obj;
        }
        int cur_pos = bgn_pos + 1;
        ByteTrieItm_fast cur = this.root;
        while (true) {
            if (nxt.Ary_is_empty()) {
                rv_obj = nxt.Val();
                rv.Init(cur_pos, rv_obj);
                return rv_obj;
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                rv_pos = cur_pos;
                rv_obj = nxt_val;
            }
            if (cur_pos == src_end) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            cur = nxt;
            b = src[cur_pos];
            if ((nxt = cur.Ary_find(b)) == null) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            ++cur_pos;
        }
    }

    public Object Match_exact(byte[] src, int bgn_pos, int end_pos) {
        Object rv = this.Match_bgn_w_byte(src[bgn_pos], src, bgn_pos, end_pos);
        return rv == null ? null : (this.match_pos - bgn_pos == end_pos - bgn_pos ? rv : null);
    }

    public Object Match_bgn(byte[] src, int bgn_pos, int end_pos) {
        return this.Match_bgn_w_byte(src[bgn_pos], src, bgn_pos, end_pos);
    }

    public Object Match_bgn_w_byte(byte b, byte[] src, int bgn_pos, int src_len) {
        this.match_pos = bgn_pos;
        ByteTrieItm_fast nxt = this.root.Ary_find(b);
        if (nxt == null) {
            return null;
        }
        Object rv = null;
        int cur_pos = bgn_pos + 1;
        ByteTrieItm_fast cur = this.root;
        while (true) {
            if (nxt.Ary_is_empty()) {
                this.match_pos = cur_pos;
                return nxt.Val();
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                this.match_pos = cur_pos;
                rv = nxt_val;
            }
            if (cur_pos == src_len) {
                return rv;
            }
            cur = nxt;
            b = src[cur_pos];
            if ((nxt = cur.Ary_find(b)) == null) {
                return rv;
            }
            ++cur_pos;
        }
    }

    public Btrie_fast_mgr Add_bry_byte(byte key, byte val) {
        return this.Add(new byte[]{key}, (Object)Byte_obj_val.new_(val));
    }

    public Btrie_fast_mgr Add_bry_byte(byte[] key, byte val) {
        return this.Add(key, (Object)Byte_obj_val.new_(val));
    }

    public Btrie_fast_mgr Add_str_byte(String key, byte val) {
        return this.Add(Bry_.new_u8(key), (Object)Byte_obj_val.new_(val));
    }

    public Btrie_fast_mgr Add(byte key, Object val) {
        return this.Add(new byte[]{key}, val);
    }

    public Btrie_fast_mgr Add(String key, Object val) {
        return this.Add(Bry_.new_u8(key), val);
    }

    public Btrie_fast_mgr Add(byte[] key, Object val) {
        if (val == null) {
            throw Err_.new_wo_type("null objects cannot be registered", "key", String_.new_u8(key));
        }
        int key_len = key.length;
        int key_end = key_len - 1;
        ByteTrieItm_fast cur = this.root;
        int i = 0;
        while (i < key_len) {
            byte b = key[i];
            ByteTrieItm_fast nxt = cur.Ary_find(b);
            if (nxt == null) {
                nxt = cur.Ary_add(b, null);
            }
            if (i == key_end) {
                nxt.Val_set(val);
            }
            cur = nxt;
            ++i;
        }
        return this;
    }

    public Btrie_fast_mgr Add_stub(byte tid, String s) {
        byte[] bry = Bry_.new_u8(s);
        Btrie_itm_stub stub = new Btrie_itm_stub(tid, bry);
        return this.Add(bry, (Object)stub);
    }

    public void Del(byte[] key) {
        int key_len = key.length;
        ByteTrieItm_fast cur = this.root;
        int i = 0;
        while (i < key_len) {
            byte b = key[i];
            ByteTrieItm_fast itm_obj = cur.Ary_find(b);
            if (itm_obj == null) break;
            ByteTrieItm_fast itm = itm_obj;
            if (i == key_len - 1) {
                if (itm.Val() == null) break;
                if (itm.Ary_is_empty()) {
                    cur.Ary_del(b);
                } else {
                    itm.Val_set(null);
                }
            } else {
                cur = itm;
            }
            ++i;
        }
    }

    public void Clear() {
        this.root.Clear();
    }

    public byte[] Replace(Bry_bfr tmp_bfr, byte[] src, int bgn, int end) {
        int pos = bgn;
        boolean dirty = false;
        while (pos < end) {
            byte b = src[pos];
            Object o = this.Match_bgn_w_byte(b, src, pos, end);
            if (o == null) {
                if (dirty) {
                    tmp_bfr.Add_byte(b);
                }
                ++pos;
                continue;
            }
            if (!dirty) {
                tmp_bfr.Add_mid(src, bgn, pos);
                dirty = true;
            }
            tmp_bfr.Add((byte[])o);
            pos = this.match_pos;
        }
        return dirty ? tmp_bfr.To_bry_and_clear() : src;
    }

    public static Btrie_fast_mgr cs() {
        return new Btrie_fast_mgr(false);
    }

    public static Btrie_fast_mgr ci_a7() {
        return new Btrie_fast_mgr(true);
    }

    public static Btrie_fast_mgr new_(boolean case_any) {
        return new Btrie_fast_mgr(case_any);
    }

    Btrie_fast_mgr(boolean case_any) {
        this.root = new ByteTrieItm_fast(0, null, case_any);
    }
}

