/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Bry_;
import gplx.Tfds;
import gplx.core.btries.Btrie_bwd_mgr;
import org.junit.Before;
import org.junit.Test;

public class Btrie_bwd_mgr_tst {
    private Btrie_bwd_mgr trie;

    @Before
    public void init() {
    }

    private void ini_setup1() {
        this.trie = new Btrie_bwd_mgr(false);
        this.run_Add("c", 1);
        this.run_Add("abc", 123);
    }

    @Test
    public void Get_by() {
        this.ini_setup1();
        this.tst_MatchAtCur("c", 1);
        this.tst_MatchAtCur("abc", 123);
        this.tst_MatchAtCur("bc", 1);
        this.tst_MatchAtCur("yzabc", 123);
        this.tst_MatchAtCur("ab", null);
    }

    @Test
    public void Fetch_intl() {
        this.trie = new Btrie_bwd_mgr(false);
        this.run_Add("a\ufffd", 1);
        this.tst_MatchAtCur("a\ufffd", 1);
        this.tst_MatchAtCur("\ufffd", null);
    }

    @Test
    public void Eos() {
        this.ini_setup1();
        this.tst_Match("ab", (byte)99, 2, 123);
    }

    @Test
    public void Match_exact() {
        this.ini_setup1();
        this.tst_MatchAtCurExact("c", 1);
        this.tst_MatchAtCurExact("bc", null);
        this.tst_MatchAtCurExact("abc", 123);
    }

    private void ini_setup2() {
        this.trie = new Btrie_bwd_mgr(false);
        this.run_Add("a", 1);
        this.run_Add("b", 2);
    }

    @Test
    public void Match_2() {
        this.ini_setup2();
        this.tst_MatchAtCur("a", 1);
        this.tst_MatchAtCur("b", 2);
    }

    private void ini_setup_caseAny() {
        this.trie = Btrie_bwd_mgr.ci_();
        this.run_Add("a", 1);
        this.run_Add("b", 2);
    }

    @Test
    public void CaseAny() {
        this.ini_setup_caseAny();
        this.tst_MatchAtCur("a", 1);
        this.tst_MatchAtCur("A", 1);
    }

    private void run_Add(String k, int val) {
        this.trie.Add(Bry_.new_u8(k), (Object)val);
    }

    private void tst_Match(String srcStr, byte b, int bgn_pos, int expd) {
        byte[] src = Bry_.new_u8(srcStr);
        Object actl = this.trie.Match(b, src, bgn_pos, -1);
        Tfds.Eq(expd, actl);
    }

    private void tst_MatchAtCur(String srcStr, Object expd) {
        byte[] src = Bry_.new_u8(srcStr);
        Object actl = this.trie.Match(src[src.length - 1], src, src.length - 1, -1);
        Tfds.Eq(expd, actl);
    }

    private void tst_MatchAtCurExact(String srcStr, Object expd) {
        byte[] src = Bry_.new_u8(srcStr);
        Object actl = this.trie.Match_exact(src, src.length - 1, -1);
        Tfds.Eq(expd, actl);
    }
}

