/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.brys.fmts;

import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Byte_ascii;
import gplx.Err_;
import gplx.Hash_adp_bry;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.core.brys.fmts.Bfr_fmt_arg;
import gplx.core.brys.fmts.Bry_fmt_itm;

public class Bry_fmt_parser_ {
    private static final byte[] Bry_arg_lhs = Bry_.new_a7("~{");

    public static Bry_fmt_itm[] Parse(byte escape, byte grp_bgn, byte grp_end, Bfr_fmt_arg[] args, byte[][] keys, byte[] src) {
        Bry_fmt_itm key_itm;
        int src_len = src.length;
        int pos = 0;
        int txt_bgn = -1;
        int key_idx = -1;
        Hash_adp_bry keys_hash = Hash_adp_bry.cs();
        List_adp list = List_adp_.New();
        while (true) {
            byte b;
            boolean is_last = pos == src_len;
            byte by = b = is_last ? escape : src[pos];
            if (b == escape) {
                if (txt_bgn != -1) {
                    list.Add(new Bry_fmt_itm(0, txt_bgn, pos));
                }
                if (is_last) break;
                if (++pos == src_len) {
                    throw Err_.new_("bry_fmtr", "fmt cannot end with escape", "escape", Byte_ascii.To_str(escape), "raw", src);
                }
                b = src[pos];
                if (b == escape) {
                    list.Add(new Bry_fmt_itm(0, pos, pos + 1));
                    ++pos;
                } else if (b == grp_bgn) {
                    int grp_end_pos;
                    if ((grp_end_pos = Bry_find_.Find_fwd(src, grp_end, ++pos)) == -1) {
                        throw Err_.new_("bry_fmtr", "grp_end missing", "grp_bgn", Byte_ascii.To_str(grp_bgn), "grp_end", Byte_ascii.To_str(grp_end), "raw", src);
                    }
                    byte[] key_bry = Bry_.Mid(src, pos, grp_end_pos);
                    key_itm = (Bry_fmt_itm)keys_hash.Get_by_bry(key_bry);
                    if (key_itm == null) {
                        key_itm = new Bry_fmt_itm(1, pos - 2, grp_end_pos + 1);
                        key_itm.Key_idx = ++key_idx;
                        keys_hash.Add(key_bry, key_itm);
                    }
                    list.Add(key_itm);
                    pos = grp_end_pos + 1;
                } else {
                    throw Err_.new_("bry_fmtr", "escape must be followed by escape or group_bgn", "escape", Byte_ascii.To_str(escape), "group_bgn", Byte_ascii.To_str(escape), "raw", src);
                }
                txt_bgn = -1;
                continue;
            }
            if (txt_bgn == -1) {
                txt_bgn = pos;
            }
            ++pos;
        }
        Bry_fmt_itm[] rv = (Bry_fmt_itm[])list.To_ary_and_clear(Bry_fmt_itm.class);
        int len = args.length;
        int i = 0;
        while (i < len) {
            Bfr_fmt_arg arg = args[i];
            key_itm = (Bry_fmt_itm)keys_hash.Get_by(arg.Key);
            if (key_itm != null) {
                key_itm.Tid = 2;
                key_itm.Arg = arg.Arg;
            }
            ++i;
        }
        len = keys.length;
        i = 0;
        while (i < len) {
            byte[] key = keys[i];
            key_itm = (Bry_fmt_itm)keys_hash.Get_by(key);
            if (key_itm != null) {
                key_itm.Key_idx = i;
            }
            ++i;
        }
        return rv;
    }

    public static byte[][] Parse_keys(byte[] src) {
        Ordered_hash list = Ordered_hash_.New_bry();
        int src_len = src.length;
        int pos = -1;
        while (pos < src_len) {
            int lhs_pos = Bry_find_.Move_fwd(src, Bry_arg_lhs, pos + 1, src_len);
            if (lhs_pos == -1) break;
            int rhs_pos = Bry_find_.Find_fwd(src, (byte)125, lhs_pos, src_len);
            if (rhs_pos == -1) {
                throw Err_.new_("bry_fmt", "unable to find closing }", "src", src);
            }
            if (rhs_pos - lhs_pos == 0) {
                throw Err_.new_("bry_fmt", "{} will result in empty key", "src", src);
            }
            byte[] key = Bry_.Mid(src, lhs_pos, rhs_pos);
            if (!list.Has(key)) {
                list.Add(key, key);
            }
            pos = rhs_pos;
        }
        return (byte[][])list.To_ary(byte[].class);
    }
}

