/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.brys;

import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Byte_;
import gplx.Byte_ascii;
import gplx.Double_;
import gplx.String_;
import gplx.Virtual;
import gplx.core.brys.Bry_err_wkr;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.core.encoders.Gfo_hzip_int_;
import gplx.core.primitives.Byte_obj_val;
import gplx.core.primitives.Int_obj_ref;

public class Bry_rdr {
    private final Int_obj_ref pos_ref = Int_obj_ref.New_neg1();
    private final Btrie_rv trv = new Btrie_rv();
    protected byte[] src;
    protected int src_end;
    protected int pos;
    private byte dflt_dlm;
    private Bry_err_wkr err_wkr = new Bry_err_wkr();
    private static final int Fail_if_missing = Integer.MIN_VALUE;

    public byte[] Src() {
        return this.src;
    }

    public int Src_end() {
        return this.src_end;
    }

    public int Pos() {
        return this.pos;
    }

    public boolean Pos_is_eos() {
        return this.pos == this.src_end;
    }

    public Bry_rdr Dflt_dlm_(byte b) {
        this.dflt_dlm = b;
        return this;
    }

    public Bry_rdr Fail_throws_err_(boolean v) {
        this.err_wkr.Fail_throws_err_(v);
        return this;
    }

    public Bry_rdr Init_by_src(byte[] src) {
        this.err_wkr.Init_by_page("", src);
        this.pos = 0;
        this.src = src;
        this.src_end = src.length;
        return this;
    }

    public Bry_rdr Init_by_page(byte[] page, byte[] src, int src_len) {
        this.err_wkr.Init_by_page(String_.new_u8(page), src);
        this.pos = 0;
        this.src = src;
        this.src_end = src_len;
        return this;
    }

    public Bry_rdr Init_by_sect(String sect, int sect_bgn, int pos) {
        this.err_wkr.Init_by_sect(sect, sect_bgn);
        this.pos = pos;
        return this;
    }

    public Bry_rdr Init_by_wkr(Bry_err_wkr wkr, String sect, int pos, int src_end) {
        this.pos = pos;
        this.src = wkr.Src();
        this.src_end = src_end;
        this.err_wkr.Init_by_page(wkr.Page(), this.src);
        this.err_wkr.Init_by_sect(sect, pos);
        return this;
    }

    public Bry_err_wkr Err_wkr() {
        return this.err_wkr;
    }

    public int Move_to(int v) {
        this.pos = v;
        return this.pos;
    }

    public int Move_by_one() {
        return this.Move_by(1);
    }

    public int Move_by(int v) {
        this.pos += v;
        return this.pos;
    }

    public int Find_fwd_lr() {
        return this.Find_fwd(this.dflt_dlm, true, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_lr(byte find) {
        return this.Find_fwd(find, true, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_lr_or(byte find, int or) {
        return this.Find_fwd(find, true, false, or);
    }

    public int Find_fwd_lr(byte[] find) {
        return this.Find_fwd(find, true, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr() {
        return this.Find_fwd(this.dflt_dlm, false, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr(byte find) {
        return this.Find_fwd(find, false, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr(byte[] find) {
        return this.Find_fwd(find, false, false, Integer.MIN_VALUE);
    }

    public int Find_fwd_rr_or(byte[] find, int or) {
        return this.Find_fwd(find, false, false, or);
    }

    private int Find_fwd(byte find, boolean ret_lhs, boolean pos_lhs, int or) {
        int find_pos = Bry_find_.Find_fwd(this.src, find, this.pos, this.src_end);
        if (find_pos == -1) {
            if (or == Integer.MIN_VALUE) {
                this.err_wkr.Fail("find failed", "find", Byte_ascii.To_str(find));
                return -1;
            }
            return or;
        }
        this.pos = find_pos + (pos_lhs ? 0 : 1);
        return ret_lhs ? find_pos : this.pos;
    }

    private int Find_fwd(byte[] find, boolean ret_lhs, boolean pos_lhs, int or) {
        int find_pos = Bry_find_.Find_fwd(this.src, find, this.pos, this.src_end);
        if (find_pos == -1) {
            if (or == Integer.MIN_VALUE) {
                this.err_wkr.Fail("find failed", "find", String_.new_u8(find));
                return -1;
            }
            return or;
        }
        this.pos = find_pos + (pos_lhs ? 0 : find.length);
        return ret_lhs ? find_pos : this.pos;
    }

    public byte Read_byte() {
        byte rv = this.src[this.pos];
        ++this.pos;
        return rv;
    }

    public byte Read_byte_to() {
        return this.Read_byte_to(this.dflt_dlm);
    }

    public byte Read_byte_to(byte to_char) {
        byte rv = this.src[this.pos];
        ++this.pos;
        if (this.pos < this.src_end) {
            if (this.src[this.pos] != to_char) {
                this.err_wkr.Fail("read byte to failed", "to", Byte_ascii.To_str(to_char));
                return 127;
            }
            ++this.pos;
        }
        return rv;
    }

    public double Read_double_to() {
        return this.Read_double_to(this.dflt_dlm);
    }

    public double Read_double_to(byte to_char) {
        byte[] bry = this.Read_bry_to(to_char);
        return Double_.parse(String_.new_a7(bry));
    }

    public int Read_int_to() {
        return this.Read_int_to(this.dflt_dlm);
    }

    public int Read_int_to_non_num() {
        return this.Read_int_to((byte)0);
    }

    public int Read_int_to(byte to_char) {
        int bgn = this.pos;
        int rv = 0;
        int negative = 1;
        while (this.pos < this.src_end) {
            byte b = this.src[this.pos++];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    rv = rv * 10 + (b - 48);
                    break;
                }
                case 45: {
                    if (negative == -1) {
                        this.err_wkr.Fail("invalid int", "mid", String_.new_u8(this.src, bgn, this.pos));
                        return Integer.MIN_VALUE;
                    }
                    negative = -1;
                    break;
                }
                default: {
                    boolean match;
                    boolean bl = match = b == to_char;
                    if (to_char == 0) {
                        --this.pos;
                        match = true;
                    }
                    if (!match) {
                        this.err_wkr.Fail("invalid int", "mid", String_.new_u8(this.src, bgn, this.pos));
                        return Integer.MIN_VALUE;
                    }
                    return rv * negative;
                }
            }
        }
        if (bgn == this.pos) {
            this.err_wkr.Fail("int is empty", new Object[0]);
            return Integer.MIN_VALUE;
        }
        return rv * negative;
    }

    public int Read_hzip_int(int reqd) {
        int rv = Gfo_hzip_int_.Decode(reqd, this.src, this.src_end, this.pos, this.pos_ref);
        this.pos = this.pos_ref.Val();
        return rv;
    }

    public byte[] Read_bry_to() {
        return this.Read_bry_to(this.dflt_dlm);
    }

    public byte[] Read_bry_to(byte b) {
        int bgn = this.pos;
        return Bry_.Mid(this.src, bgn, this.Find_fwd_lr(b));
    }

    public boolean Is(byte find) {
        boolean rv;
        boolean bl = rv = this.src[this.pos] == find;
        if (rv) {
            ++this.pos;
        }
        return rv;
    }

    public boolean Is(byte[] find) {
        int find_len = find.length;
        int find_end = this.pos + find_len;
        boolean rv = Bry_.Match(this.src, this.pos, find_end, find, 0, find_len);
        if (rv) {
            this.pos = find_end;
        }
        return rv;
    }

    public int Chk(byte find) {
        if (this.src[this.pos] != find) {
            this.err_wkr.Fail("failed check", "chk", Byte_.To_str(find));
            return -1;
        }
        ++this.pos;
        return this.pos;
    }

    public int Chk(byte[] find) {
        int find_end = this.pos + find.length;
        if (!Bry_.Match(this.src, this.pos, find_end, find)) {
            this.err_wkr.Fail("failed check", "chk", String_.new_u8(find));
            return -1;
        }
        this.pos = find_end;
        return this.pos;
    }

    public byte Chk(Btrie_slim_mgr trie) {
        return this.Chk(trie, this.pos, this.src_end);
    }

    public void Chk_trie_val(Btrie_slim_mgr trie, byte val) {
        byte rv = this.Chk_or(trie, (byte)127);
        if (rv == 127) {
            this.err_wkr.Fail("failed trie check", "mid", String_.new_u8(Bry_.Mid_by_len_safe(this.src, this.pos, 16)));
        }
    }

    public Object Chk_trie_as_obj(Btrie_rv trv, Btrie_slim_mgr trie) {
        Object rv = trie.Match_at(trv, this.src, this.pos, this.src_end);
        if (rv == null) {
            this.err_wkr.Fail("failed trie check", "mid", String_.new_u8(Bry_.Mid_by_len_safe(this.src, this.pos, 16)));
        }
        return rv;
    }

    public byte Chk_or(Btrie_rv trv, Btrie_slim_mgr trie, byte or) {
        Object rv_obj = trie.Match_at(trv, this.src, this.pos, this.src_end);
        return rv_obj == null ? or : ((Byte_obj_val)rv_obj).Val();
    }

    public byte Chk_or(Btrie_slim_mgr trie, byte or) {
        return this.Chk_or(trie, this.pos, this.src_end, or);
    }

    public byte Chk(Btrie_slim_mgr trie, int itm_bgn, int itm_end) {
        byte rv = this.Chk_or(trie, itm_bgn, itm_end, (byte)127);
        if (rv == 127) {
            this.err_wkr.Fail("failed trie check", "mid", String_.new_u8(Bry_.Mid_by_len_safe(this.src, this.pos, 16)));
            return 127;
        }
        return rv;
    }

    public byte Chk_or(Btrie_slim_mgr trie, int itm_bgn, int itm_end, byte or) {
        Object rv_obj = trie.Match_at(this.trv, this.src, itm_bgn, itm_end);
        if (rv_obj == null) {
            return or;
        }
        this.pos = this.trv.Pos();
        return ((Byte_obj_val)rv_obj).Val();
    }

    @Virtual
    public Bry_rdr Skip_ws() {
        while (this.pos < this.src_end) {
            switch (this.src[this.pos]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.pos;
                    break;
                }
                default: {
                    return this;
                }
            }
        }
        return this;
    }

    public Bry_rdr Skip_alpha_num_under() {
        while (this.pos < this.src_end) {
            switch (this.src[this.pos]) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    ++this.pos;
                    break;
                }
                default: {
                    return this;
                }
            }
        }
        return this;
    }
}

