/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Array_;
import gplx.Err_;
import gplx.Int_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.List_adp_base;
import gplx.Tfds;
import org.junit.Before;
import org.junit.Test;

public class List_adp_tst {
    List_adp list;
    List_adp_base listBase;

    @Before
    public void setup() {
        this.list = List_adp_.New();
        this.listBase = (List_adp_base)this.list;
    }

    @Test
    public void Add() {
        Tfds.Eq(0, this.list.Count());
        this.list.Add("0");
        Tfds.Eq(1, this.list.Count());
    }

    @Test
    public void Add_changeCapacity() {
        int capacity = 8;
        int i = 0;
        while (i < capacity) {
            this.list.Add("0");
            ++i;
        }
        Tfds.Eq(capacity, this.list.Count());
        Tfds.Eq(capacity, this.listBase.Capacity());
        this.list.Add(capacity);
        Tfds.Eq(capacity + 1, this.list.Count());
        Tfds.Eq(capacity * 2, this.listBase.Capacity());
    }

    @Test
    public void Get_at() {
        this.list.Add("0");
        Tfds.Eq("0", this.list.Get_at(0));
    }

    @Test
    public void Fetch_many() {
        this.list_AddMany("0", "1");
        Tfds.Eq("0", this.list.Get_at(0));
        Tfds.Eq("1", this.list.Get_at(1));
    }

    @Test
    public void FetchAt_fail() {
        try {
            this.list.Get_at(0);
        }
        catch (Exception exc) {
            Err_.Noop(exc);
            return;
        }
        Tfds.Fail("Get_at should fail for out of bound index", new Object[0]);
    }

    @Test
    public void Del_at() {
        this.list.Add("0");
        Tfds.Eq(1, this.list.Count());
        this.list.Del_at(0);
        Tfds.Eq(0, this.list.Count());
    }

    @Test
    public void DelAt_shiftDown() {
        this.list_AddMany("0", "1");
        Tfds.Eq(this.list.Count(), 2);
        this.list.Del_at(0);
        Tfds.Eq(1, this.list.Count());
        Tfds.Eq("1", this.list.Get_at(0));
    }

    @Test
    public void DelAt_fail() {
        try {
            this.list.Del_at(0);
        }
        catch (Exception exc) {
            Err_.Noop(exc);
            return;
        }
        Tfds.Fail("Del_at should fail for out of bound index", new Object[0]);
    }

    @Test
    public void Del() {
        this.list.Add("0");
        Tfds.Eq(1, this.list.Count());
        this.list.Del("0");
        Tfds.Eq(0, this.list.Count());
    }

    @Test
    public void Del_matchMember() {
        this.list_AddMany("0", "1");
        Tfds.Eq(2, this.list.Count());
        this.list.Del("1");
        Tfds.Eq(1, this.list.Count());
        Tfds.Eq("0", this.list.Get_at(0));
    }

    @Test
    public void Del_matchFirst() {
        this.list_AddMany("0", "1", "0");
        Tfds.Eq(3, this.list.Count());
        this.list.Del("0");
        this.tst_Enumerator("1", "0");
    }

    @Test
    public void Enumerator() {
        this.list_AddMany("0", "1", "2");
        this.tst_Enumerator("0", "1", "2");
    }

    @Test
    public void Enumerator_stateLess() {
        this.list_AddMany("0", "1", "2");
        this.tst_Enumerator("0", "1", "2");
        this.tst_Enumerator("0", "1", "2");
    }

    @Test
    public void Enumerator_recursive() {
        int pos = 0;
        this.list_AddMany("0", "1", "2");
        for (Object valObj : this.list) {
            String val = (String)valObj;
            Tfds.Eq(Int_.To_str(pos++), val);
            this.tst_Enumerator("0", "1", "2");
        }
    }

    @Test
    public void Clear() {
        int capacity = 8;
        int i = 0;
        while (i < capacity + 1) {
            this.list.Add("0");
            ++i;
        }
        Tfds.Eq(capacity * 2, this.listBase.Capacity());
        this.list.Clear();
        Tfds.Eq(0, this.list.Count());
        Tfds.Eq(16, this.listBase.Capacity());
    }

    @Test
    public void Clear_empty() {
        this.list.Clear();
        Tfds.Eq(0, this.list.Count());
    }

    @Test
    public void Reverse() {
        this.list_AddMany("0", "1", "2");
        this.list.Reverse();
        this.tst_Enumerator("2", "1", "0");
    }

    @Test
    public void Reverse_empty() {
        this.list.Reverse();
    }

    @Test
    public void Sort() {
        this.list_AddMany("2", "0", "1");
        this.list.Sort();
        this.tst_Enumerator("0", "1", "2");
    }

    @Test
    public void Sort_empty() {
        this.list.Sort();
    }

    @Test
    public void Xto_bry() {
        this.list_AddMany("0", "1");
        String[] ary = (String[])this.list.To_ary(String.class);
        Tfds.Eq_nullNot(ary);
        Tfds.Eq(2, Array_.Len(ary));
    }

    @Test
    public void XtoAry_empty() {
        String[] ary = (String[])this.list.To_ary(String.class);
        Tfds.Eq_nullNot(ary);
        Tfds.Eq(0, Array_.Len(ary));
    }

    @Test
    public void Shuffle() {
        int i = 0;
        while (i < 25) {
            this.list.Add(i);
            ++i;
        }
        this.list.Shuffle();
        int hasMovedCount = 0;
        int i2 = 0;
        while (i2 < this.list.Count()) {
            int val = Int_.cast(this.list.Get_at(i2));
            if (val != i2) {
                ++hasMovedCount;
            }
            ++i2;
        }
        Tfds.Eq_true(hasMovedCount > 0, "all documents have the same index", new Object[0]);
        int count = this.list.Count();
        int i3 = 0;
        while (i3 < count) {
            this.list.Del(i3);
            ++i3;
        }
        Tfds.Eq(0, this.list.Count(), "shuffled list does not have the same contents as original list", new Object[0]);
    }

    @Test
    public void Shuffle_empty() {
        this.list.Shuffle();
    }

    @Test
    public void Move_to() {
        this.run_ClearAndAdd("0", "1", "2").run_MoveTo(0, 1).tst_Order("1", "0", "2");
        this.run_ClearAndAdd("0", "1", "2").run_MoveTo(0, 2).tst_Order("1", "2", "0");
        this.run_ClearAndAdd("0", "1", "2").run_MoveTo(2, 1).tst_Order("0", "2", "1");
        this.run_ClearAndAdd("0", "1", "2").run_MoveTo(2, 0).tst_Order("2", "0", "1");
    }

    @Test
    public void Del_range() {
        this.run_ClearAndAdd("0", "1", "2", "3").tst_DelRange(0, 2, "3");
        this.run_ClearAndAdd("0", "1", "2", "3").tst_DelRange(0, 3, new String[0]);
        this.run_ClearAndAdd("0", "1", "2", "3").tst_DelRange(1, 2, "0", "3");
        this.run_ClearAndAdd("0", "1", "2", "3").tst_DelRange(1, 3, "0");
        this.run_ClearAndAdd("0", "1", "2", "3").tst_DelRange(0, 3, new String[0]);
        this.run_ClearAndAdd("0", "1", "2", "3").tst_DelRange(0, 0, "1", "2", "3");
    }

    void tst_DelRange(int bgn, int end, String ... expd) {
        this.list.Del_range(bgn, end);
        Tfds.Eq_ary_str(expd, this.list.To_str_ary());
    }

    List_adp_tst run_ClearAndAdd(String ... ary) {
        this.list.Clear();
        int i = 0;
        while (i < Array_.Len(ary)) {
            String val = ary[i];
            this.list.Add(val);
            ++i;
        }
        return this;
    }

    List_adp_tst run_MoveTo(int elemPos, int newPos) {
        this.list.Move_to(elemPos, newPos);
        return this;
    }

    List_adp_tst tst_Order(String ... expd) {
        String[] actl = (String[])this.list.To_ary(String.class);
        Tfds.Eq_ary(expd, actl);
        return this;
    }

    void list_AddMany(String ... ary) {
        int i = 0;
        while (i < Array_.Len(ary)) {
            String val = ary[i];
            this.list.Add(val);
            ++i;
        }
    }

    void tst_Enumerator(String ... expd) {
        int pos = 0;
        int expdLength = Array_.Len(expd);
        int i = 0;
        while (i < expdLength) {
            String val = expd[i];
            Tfds.Eq(expd[pos++], val);
            ++i;
        }
        Tfds.Eq(pos, expdLength);
    }
}

