/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk_;
import gplx.Gfo_usr_dlg__log;
import gplx.GfsCtx;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.String_;
import gplx.Usr_log_fil;
import gplx.core.brys.fmtrs.Bry_fmtr;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;

public class Gfo_usr_dlg__log_base
implements Gfo_usr_dlg__log {
    private int archive_dirs_max = 8;
    private Io_url log_dir;
    private Io_url err_fil;
    private Ordered_hash queued_list = Ordered_hash_.New();
    private Bry_fmtr fmtr = Bry_fmtr.New__tmp();
    private Bry_bfr tmp_bfr = Bry_bfr_.Reset(255);
    private boolean queue_enabled;
    private boolean enabled = true;
    private Io_url session_dir;
    private Io_url session_fil;
    private String_bldr sb = String_bldr_.new_thread();
    public static final String Invk_enabled_ = "enabled_";
    public static final String Invk_archive_dirs_max_ = "archive_dirs_max_";
    public static final String Invk_log_dir_ = "log_dir_";
    static final String Dir_name_log = "log";
    static final String Dir_name_current = "current";
    public static final Gfo_usr_dlg__log_base Instance = new Gfo_usr_dlg__log_base();

    @Override
    public boolean Queue_enabled() {
        return this.queue_enabled;
    }

    @Override
    public void Queue_enabled_(boolean v) {
        this.queue_enabled = v;
        if (!v) {
            this.Flush();
        }
    }

    @Override
    public boolean Enabled() {
        return this.enabled;
    }

    @Override
    public void Enabled_(boolean v) {
        this.enabled = v;
    }

    @Override
    public Io_url Session_dir() {
        return this.session_dir;
    }

    @Override
    public Io_url Session_fil() {
        return this.session_fil;
    }

    private void Flush() {
        int queued_len = this.queued_list.Count();
        int i = 0;
        while (i < queued_len) {
            Usr_log_fil fil = (Usr_log_fil)this.queued_list.Get_at(i);
            if (fil.Url() == null) {
                fil.Url_(this.session_dir.GenSubFil("session.txt"));
            }
            fil.Flush();
            ++i;
        }
    }

    @Override
    public Io_url Log_dir() {
        return this.log_dir;
    }

    @Override
    public void Log_dir_(Io_url log_dir) {
        this.log_dir = log_dir;
        this.session_dir = log_dir.GenSubDir(Dir_name_current);
        this.session_fil = this.session_dir.GenSubFil("session.txt");
        this.err_fil = this.session_dir.GenSubFil("err.txt");
    }

    @Override
    public void Log_term() {
        if (!this.enabled) {
            return;
        }
        Io_url[] archive_dirs = Io_mgr.Instance.QueryDir_args(this.log_dir).DirInclude_().DirOnly_().ExecAsUrlAry();
        int archive_dirs_len = archive_dirs.length;
        int session_cutoff = archive_dirs_len - this.archive_dirs_max;
        int i = 0;
        while (i < session_cutoff) {
            Io_url archive_dir = archive_dirs[i];
            Io_mgr.Instance.DeleteDirDeep(archive_dir);
            this.Log_to_session("archive dir del: " + this.session_dir.Raw());
            ++i;
        }
        this.Log_to_session("app term");
        this.MoveCurrentToArchive(this.session_dir);
    }

    private void MoveCurrentToArchive(Io_url dir) {
        Io_mgr.Instance.MoveDirDeep(dir, dir.OwnerDir().GenSubDir(Datetime_now.Get().XtoStr_fmt_yyyyMMdd_HHmmss_fff()));
    }

    public void Log_info(boolean warn, String s) {
        if (warn) {
            this.Log_to_err(s);
        } else {
            this.Log_to_session(s);
        }
    }

    @Override
    public void Log_msg_to_url_fmt(Io_url url, String fmt, Object ... args) {
        if (!this.enabled) {
            return;
        }
        String msg = this.Bld_msg(String_.new_u8(this.fmtr.Fmt_(fmt).Bld_bry_many(this.tmp_bfr, args)));
        this.Log_msg(url, msg);
        this.Log_msg(this.session_fil, msg);
    }

    @Override
    public void Log_to_session_fmt(String fmt, Object ... args) {
        this.Log_to_session(String_.new_u8(this.fmtr.Fmt_(fmt).Bld_bry_many(this.tmp_bfr, args)));
    }

    @Override
    public void Log_to_session(String s) {
        if (!this.enabled) {
            return;
        }
        String line = this.Bld_msg(s);
        this.Log_msg(this.session_fil, line);
    }

    @Override
    public void Log_to_session_direct(String s) {
        if (!this.enabled) {
            return;
        }
        this.Log_msg(this.session_fil, s);
    }

    @Override
    public void Log_to_err(String s) {
        if (!this.enabled) {
            return;
        }
        try {
            String line = this.Bld_msg(s);
            this.Log_msg(this.session_fil, line);
            this.Log_msg(this.err_fil, line);
        }
        catch (Exception e) {
            Err_.Noop(e);
        }
    }

    private String Bld_msg(String s) {
        return this.sb.Add(Datetime_now.Get_force().XtoUtc().XtoStr_fmt_yyyyMMdd_HHmmss_fff()).Add(" ").Add(s).Add_char_nl().To_str_and_clear();
    }

    private void Log_msg(Io_url url, String txt) {
        if (this.queue_enabled) {
            String url_raw = url == null ? "mem" : url.Raw();
            Usr_log_fil fil = (Usr_log_fil)this.queued_list.Get_by(url_raw);
            if (fil == null) {
                fil = new Usr_log_fil(url);
                this.queued_list.Add(url_raw, fil);
            }
            fil.Add(txt);
        } else {
            Io_mgr.Instance.AppendFilStr(url, txt);
        }
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (ctx.Match(k, Invk_enabled_)) {
            this.enabled = m.ReadYn("v");
        } else if (ctx.Match(k, Invk_archive_dirs_max_)) {
            this.archive_dirs_max = m.ReadInt("v");
        } else if (ctx.Match(k, Invk_log_dir_)) {
            this.log_dir = m.ReadIoUrl("v");
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }
}

