/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Array_;
import gplx.Err_;
import gplx.Int_;
import gplx.Internal;
import gplx.String_;
import gplx.core.errs.Err_msg;

public class Err
extends RuntimeException {
    private final boolean is_gplx;
    private final String trace;
    private Err_msg[] msgs_ary = new Err_msg[8];
    private int msgs_len = 8;
    private int msgs_idx = 0;
    private boolean logged;
    private int trace_ignore = 0;

    public Err(boolean is_gplx, String trace, String type, String msg, Object ... args) {
        this.is_gplx = is_gplx;
        this.trace = is_gplx ? Err_.Trace_lang(this) : trace;
        this.Msgs_add(type, msg, args);
    }

    public boolean Logged() {
        return this.logged;
    }

    public Err Logged_y_() {
        this.logged = true;
        return this;
    }

    public int Trace_ignore() {
        return this.trace_ignore;
    }

    public Err Trace_ignore_add_1_() {
        ++this.trace_ignore;
        return this;
    }

    public Err Args_add(Object ... args) {
        this.msgs_ary[this.msgs_idx - 1].Args_add(args);
        return this;
    }

    @Internal
    protected void Msgs_add(String type, String msg, Object[] args) {
        if (this.msgs_idx == this.msgs_len) {
            int new_len = this.msgs_len * 2;
            Err_msg[] new_ary = new Err_msg[new_len];
            Array_.Copy_to(this.msgs_ary, new_ary, 0);
            this.msgs_ary = new_ary;
            this.msgs_len = new_len;
        }
        this.msgs_ary[this.msgs_idx] = new Err_msg(type, msg, args);
        ++this.msgs_idx;
    }

    public String To_str__full() {
        return this.To_str(false, true);
    }

    public String To_str__log() {
        return this.To_str(true, true);
    }

    public String To_str__msg_only() {
        return this.msgs_idx == 0 ? "<<MISSING ERROR MESSAGE>>" : this.msgs_ary[0].To_str_wo_type();
    }

    public String To_str__top_wo_args() {
        return this.msgs_idx == 0 ? "<<MISSING ERROR MESSAGE>>" : this.msgs_ary[0].To_str_wo_args();
    }

    private String To_str(boolean called_by_log, boolean include_trace) {
        String nl_str = called_by_log ? "\t" : "\n";
        String rv = "";
        int i = 0;
        while (i < this.msgs_idx) {
            rv = String.valueOf(rv) + "[err " + Int_.To_str(i) + "] " + String_.Replace(this.msgs_ary[i].To_str(), "\n", nl_str) + nl_str;
            ++i;
        }
        if (include_trace) {
            rv = String.valueOf(rv) + "[trace]:" + Err.Trace_to_str(this.is_gplx, called_by_log, this.trace_ignore, this.trace == null ? Err_.Trace_lang(this) : this.trace);
        }
        return rv;
    }

    @Override
    public String getMessage() {
        return this.To_str__msg_only();
    }

    public static String Trace_to_str(boolean is_gplx, boolean called_by_log, int ignore_lines, String trace) {
        if (trace == null) {
            return "";
        }
        String[] lines = String_.Split_lang(trace, '\n');
        int lines_len = lines.length;
        int line_bgn = 0;
        if (is_gplx) {
            int i = 0;
            while (i < lines_len) {
                String line = lines[i];
                if (!String_.Has_at_bgn(line, "gplx.Err_.new")) {
                    line_bgn = i + ignore_lines;
                    break;
                }
                ++i;
            }
        }
        String rv = "";
        String line_bgn_dlm = called_by_log ? "\t  " : "\n  ";
        int i = line_bgn;
        while (i < lines_len) {
            rv = String.valueOf(rv) + line_bgn_dlm + lines[i];
            ++i;
        }
        return rv;
    }
}

