/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.DateAdp;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.core.times.DateAdp_parser;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateAdp_
implements Gfo_invk {
    public static final String Cls_ref_name = "Date";
    public static final Class<?> Cls_ref_type = DateAdp.class;
    public static final String Invk_Now = "Now";
    public static final DateAdp MinValue = new DateAdp(1, 1, 1, 0, 0, 0, 0);
    public static final DateAdp MaxValue = new DateAdp(9999, 12, 31, 23, 59, 59, 999);
    static DateAdp_parser date_parser = DateAdp_parser.new_();
    public static final DateAdp_ Gfs = new DateAdp_();
    static int[] DaysInMonth_ary = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int SegIdx_year = 0;
    public static final int SegIdx_month = 1;
    public static final int SegIdx_day = 2;
    public static final int SegIdx_hour = 3;
    public static final int SegIdx_minute = 4;
    public static final int SegIdx_second = 5;
    public static final int SegIdx_frac = 6;
    public static final int SegIdx_dayOfWeek = 7;
    public static final int SegIdx_weekOfYear = 8;
    public static final int SegIdx_dayOfYear = 9;
    public static final int SegIdx__max = 10;
    public static final String Fmt_iso8561_date_time = "yyyy-MM-dd HH:mm:ss";
    public static final String Fmt__yyyyMMdd = "yyyyMMdd";

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (ctx.Match(k, Invk_Now)) {
            return Datetime_now.Get();
        }
        return Gfo_invk_.Rv_unhandled;
    }

    public static DateAdp new_(int year, int month, int day, int hour, int minute, int second, int frac) {
        return new DateAdp(year, month, day, hour, minute, second, frac);
    }

    public static DateAdp seg_(int[] ary) {
        int ary_len = ary.length;
        int y = ary_len > 0 ? ary[0] : 1;
        int M = ary_len > 1 ? ary[1] : 1;
        int d = ary_len > 2 ? ary[2] : 1;
        int h = ary_len > 3 ? ary[3] : 0;
        int m = ary_len > 4 ? ary[4] : 0;
        int s = ary_len > 5 ? ary[5] : 0;
        int f = ary_len > 6 ? ary[6] : 0;
        return new DateAdp(y, M, d, h, m, s, f);
    }

    public static DateAdp cast(Object arg) {
        try {
            return (DateAdp)arg;
        }
        catch (Exception exc) {
            throw Err_.new_type_mismatch_w_exc(exc, DateAdp.class, arg);
        }
    }

    public static DateAdp parse_iso8561_or(String raw, DateAdp or) {
        try {
            return DateAdp_.parse_iso8561(raw);
        }
        catch (Exception e) {
            Err_.Noop(e);
            return or;
        }
    }

    public static DateAdp parse_iso8561(String raw) {
        int[] ary = date_parser.Parse_iso8651_like(raw);
        if (ary[1] < 1 || ary[1] > 12) {
            return MinValue;
        }
        if (ary[2] < 1 || ary[2] > 31) {
            return MinValue;
        }
        return new DateAdp(ary[0], ary[1], ary[2], ary[3], ary[4], ary[5], ary[6]);
    }

    public static DateAdp parse_gplx(String raw) {
        int[] ary = date_parser.Parse_iso8651_like(raw);
        if (ary[1] < 1 || ary[1] > 12) {
            return MinValue;
        }
        if (ary[2] < 1 || ary[2] > 31) {
            return MinValue;
        }
        return new DateAdp(ary[0], ary[1], ary[2], ary[3], ary[4], ary[5], ary[6]);
    }

    public static DateAdp dateTime_(GregorianCalendar v) {
        return new DateAdp(v);
    }

    public static DateAdp dateTime_obj_(Object v) {
        return new DateAdp((GregorianCalendar)v);
    }

    public static int DaysInMonth(DateAdp date) {
        int rv = DaysInMonth_ary[date.Month() - 1];
        if (rv == 28 && DateAdp_.IsLeapYear(date.Year())) {
            rv = 29;
        }
        return rv;
    }

    public static boolean IsLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 400 == 0) {
            return true;
        }
        return year % 100 != 0;
    }

    public static DateAdp unixtime_utc_seconds_(long v) {
        return DateAdp_.unixtime_utc_ms_(v * 1000L);
    }

    public static DateAdp parse_fmt_or(String raw, String fmt, DateAdp or) {
        try {
            return DateAdp_.parse_fmt(raw, fmt);
        }
        catch (Exception e) {
            Err_.Noop(e);
            return or;
        }
    }

    public static DateAdp db_(Object v) {
        Timestamp ts = (Timestamp)v;
        Calendar gc = Calendar.getInstance();
        gc.setTimeInMillis(ts.getTime());
        return new DateAdp(gc);
    }

    public static DateAdp parse_(String raw) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        Date d = null;
        try {
            d = sdf.parse(raw);
        }
        catch (ParseException e) {
            throw Err_.new_("parse", "failed to parse to DateAdp", "raw", raw);
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.setTime(d);
        return DateAdp_.dateTime_(cal);
    }

    public static DateAdp parse_fmt(String raw, String fmt) {
        fmt = fmt.replace('t', 'a');
        fmt = fmt.replace('f', 'S');
        SimpleDateFormat sdf = new SimpleDateFormat(fmt, Locale.US);
        Date d = null;
        try {
            d = sdf.parse(raw);
        }
        catch (ParseException e) {
            throw Err_.new_("parse", "failed to parse to DateAdp", "raw", raw, "fmt", fmt);
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.setTime(d);
        return DateAdp_.dateTime_(cal);
    }

    public static DateAdp unixtime_utc_ms_(long v) {
        return DateAdp_.unixtime_lcl_ms_(v).XtoUtc();
    }

    public static DateAdp unixtime_lcl_ms_(long v) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(v);
        return new DateAdp(c);
    }

    public static String Xto_str_fmt_or(DateAdp v, String fmt, String or) {
        return v == null ? or : v.XtoStr_fmt(fmt);
    }
}

